/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QTextBrowser>
class QLineEdit;
class QPushButton;
class UrpoConnectionSettings;

/*! GUI dialog for Urpo Setting

   @author Arto Hyvättinen
   @date 2010-06-13
   @version 0.1

   Dialog for settings. Remember to set setSettings() and setHelp().
   Designed for modeless use (in modal can't show help

  */
class SettingsDialog : public QDialog
{
    Q_OBJECT
public:
    explicit SettingsDialog(QWidget *parent = 0);
    /*! Set UrpoConnection having connection settings */
    void setSettings(UrpoConnectionSettings* settings);
    /*! Set QTextBrowser showing help */
    void setHelp(QTextBrowser* helpWidget);
signals:

public slots:
    void okay();
    void serverChanged(const QString& text);
    void browse();
    void showHelp();

private:
    QLineEdit*  serverEdit;
    QLineEdit*  userEdit;
    QLineEdit*  identityEdit;
    QPushButton*    browseButton;
    QPushButton*    okButton;
    QPushButton*    helpButton;
    UrpoConnectionSettings* settings_;
    QTextBrowser*    helpWidget_;

};

#endif // SETTINGSDIALOG_H
