/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#include "printerlistjob.h"
#include "urpoconnection.h"

PrinterListJob::PrinterListJob(UrpoConnection* connection) :
    UrpoJob(connection)
{
    process_=0;
}


void PrinterListJob::startJob()
{
    process_= newProcess();

    // ssh command getting printers of cups
    QString command = "ssh ";
    command.append(getConnection()->getKeyOption());
    command.append(getConnection()->getHostString());
    command.append(" env LANG=en lpstat -p");

    // When finished, call doList
    connect( process_, SIGNAL(finished(bool)), this, SLOT(doList(bool)));
    process_->start(command);
}

void PrinterListJob::cancelJob()
{
    if(process_)
        process_->terminate();
    finish(Cancelled);
}

void PrinterListJob::doList(bool success)
{
    if( process_ && success )
    {
        foreach(QString line, process_->getOutput())
        {
            if(!line.section(' ',1,1).isEmpty())
                printers_.append( line.section(' ',1,1));
            // List of printers!
        }
        finish(Successed);
    }
    else
    {
        // Error!
        // Set error message
        switch( process_->getError() )
        {
        case UrpoProcess::ProcessError :
            fail( tr("Failed to run ssh client.")); break;
        case UrpoProcess::ConnectionError:
            fail( tr("Failed to connect host")); break;
        case UrpoProcess::Timeout:
            fail( tr("Time out or authentication error")); break;
        case UrpoProcess::Cancelled:
            fail( tr("User cancelled")); break;
        default:
            fail( tr("Connection failed"));
        }
    }
}
