/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#include "urpojob.h"

#include "urpoconnection.h"

UrpoJob::UrpoJob(UrpoConnection* connection) :
    QObject(0)
{
       connection_=connection;
       // Connect debug monitor
       if( connection_->getDebugMonitor())
           connect(this,SIGNAL(debugMessage(QString)),connection_->getDebugMonitor(),SLOT(debugMessage(QString)));

       status_ = Ready;
}


void UrpoJob::sendDebugMessage(QString message)
{
    emit debugMessage(message);
}

UrpoProcess* UrpoJob::newProcess()
{
    UrpoProcess* process = new UrpoProcess( this );
    // Connect debug monitor
    connect( process, SIGNAL(debugMessage(QString)), connection_->getDebugMonitor(), SLOT(debugMessage(QString)));
    return process;
}

void UrpoJob::finish(JobStatus status)
{
    setStatus( status );
    if( status == Successed )
        emit finished(true);
    else
        emit finished(false);
}

void UrpoJob::fail(QString errorString)
{
    setStatus( Failed );
    emit finished(false, errorString);
}
