//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#ifndef FILESDIALOG_H
#define FILESDIALOG_H

#include <QtGui/QMainWindow>
#include "btconnection.h"

namespace Ui {
	class FilesDialog;
}

class FilesDialog : public QMainWindow {
	Q_OBJECT

public:
	FilesDialog(QWidget *parent, BtConnection*, TorrentData);
	~FilesDialog();

protected:
	void changeEvent(QEvent *e);

private:
	Ui::FilesDialog *m_ui;
	BtConnection *Connection;
	TorrentData Data;
	QMap<int, TFPriority> Changes;
	void Reload();

private slots:
	void UpdateData();
	void LoadStatus();
	void SetStatus(QString);
	void ApplyChanges();
	void RevertChanges();
	void Poll(){
		Connection->GetFiles(Data.Hash);
	}
};

#endif // FILESDIALOG_H
