//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#ifndef BTCONNECTION_H
#define BTCONNECTION_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QStringList>
#include "torrentdata.h"

class MainWindow;

class BtConnection : public QObject{
	Q_OBJECT

private:
	QNetworkAccessManager *manager;
	MainWindow *Parent;
	QString RawDataCache;
	QList<TorrentData> torrents;
	QStringList labels;
	QMap<QString, QList<TorrentFile> > filelists;
	QString token;
	QString cacheID;

	QString BaseUrl(bool);

private slots:
	void EndQuery(QNetworkReply*);

signals:
	void Updating();
	void QueryComplete();
	void Error(QString);

public:
	void UpdateToken();
	QStringList Labels(){return labels;	}
	QList<TorrentData> Torrents(){return torrents;}
	int GetIndex(QString hash){
		for(int i = 0; i < torrents.length(); i += 1)
			if(torrents[i].Hash == hash)
				return i;

		return -1;
	}

	BtConnection(MainWindow*);
	~BtConnection();
	void ExecuteQuery(QString);
	void SetLabel(QString hash, QString label);
	void Start(QString hash);
	void ForceStart(QString hash);
	void Pause(QString hash);
	void Unpause(QString hash);
	void Stop(QString hash);
	void Remove(QString hash, bool data);
	void AddFile(QString path);
	void AddUrl(QString url);
	void GetFiles(QString hash);
	void SetFilePriority(QString hash, TFPriority priority, int file);
	void SetFilePriority(QString hash, TFPriority priority, QList<int> files);

public slots:
	void GetTorrents(bool cached = true);

};

#endif // BTCONNECTION_H
