//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#ifndef TORRENTDIALOG_H
#define TORRENTDIALOG_H

#include <QtGui/QMainWindow>
#include "btconnection.h"
#include "torrentdata.h"

namespace Ui {
	class TorrentDialog;
}

class TorrentDialog : public QMainWindow {
	Q_OBJECT
public:
	TorrentDialog(QWidget *parent, BtConnection *con, TorrentData data);
	~TorrentDialog();

protected:
	void changeEvent(QEvent *e);
	void closeEvent(QCloseEvent* event);

private:
	Ui::TorrentDialog *m_ui;
	TorrentData Data;
	BtConnection *Connection;
	bool Updating;

	void Reload();
private slots:
	void UpdateData();
	void LabelChanged(QString);
	void StartTor();
	void ForceTor();
	void StopTor();
	void PauseTor();
	void RemoveTor();
	void ViewFiles();
};

#endif // TORRENTDIALOG_H
