//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QtGui/QMainWindow>
#include <QSettings>
#include "mainwindow.h"

namespace Ui {
	class SettingsDialog;
}

class SettingsDialog : public QMainWindow {
	Q_OBJECT
public:
	SettingsDialog(MainWindow *parent = 0);
	~SettingsDialog();

protected:
	void changeEvent(QEvent *e);
	void closeEvent(QCloseEvent*);

private:
	Ui::SettingsDialog *m_ui;
	MainWindow* Parent;

private slots:
	void Save();
	void Reload();

signals:
	void closed();
};

#endif // SETTINGSDIALOG_H
