//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "mainwindow.h"

SettingsDialog::SettingsDialog(MainWindow *parent) :
        QMainWindow(parent), m_ui(new Ui::SettingsDialog){
	Parent = parent;
	m_ui->setupUi(this);
	m_ui->scrollArea->setProperty("FingerScrollable", true);

	m_ui->RefreshRateCmb->addItem("ms", 1);
	m_ui->RefreshRateCmb->addItem("sec", 1000);
	m_ui->RefreshRateCmb->addItem("min", 1000 * 60);

	connect(m_ui->SaveBtn, SIGNAL(clicked()),
			this, SLOT(Save()));
	connect(m_ui->RevertBtn, SIGNAL(clicked()),
			this, SLOT(Reload()));
	connect(parent->connection, SIGNAL(Error(QString)),
			this, SLOT(Reload()));

	Reload();
}

SettingsDialog::~SettingsDialog(){
	delete m_ui;
}

void SettingsDialog::changeEvent(QEvent *e){
        QWidget::changeEvent(e);
	switch (e->type()) {
	case QEvent::LanguageChange:
		m_ui->retranslateUi(this);
		break;
	default:
		break;
	}
}

void SettingsDialog::Save(){
	Parent->setHostname(m_ui->HostnameTxt->text());
	Parent->setPortNo(m_ui->PortNoSB->value());
	Parent->setUsername(m_ui->UsernameTxt->text());
	Parent->setPassword(m_ui->PasswordTxt->text());
	Parent->setRefreshRate(m_ui->RefreshRateSpin->value()
		* m_ui->RefreshRateCmb->itemData(m_ui->RefreshRateCmb->currentIndex()).toInt());
	Parent->setAutoUpdatesEnabled(m_ui->UpdatesEnabledChk->isChecked());
}
void SettingsDialog::Reload(){
	m_ui->HostnameTxt->setText(Parent->Hostname());
	m_ui->PortNoSB->setValue(Parent->PortNo());
	m_ui->UsernameTxt->setText(Parent->Username());
	m_ui->PasswordTxt->setText(Parent->Password());
	m_ui->UpdatesEnabledChk->setChecked(Parent->Settings->value("AutoUpdatesEnabled", true).toBool()); //override default value

	if(Parent->RefreshRate() >= 1000){ //sec
		m_ui->RefreshRateSpin->setValue(Parent->RefreshRate() / 1000);
		m_ui->RefreshRateCmb->setCurrentIndex(1);
	}else if(Parent->RefreshRate() >= 1000 * 60){ //min
		m_ui->RefreshRateSpin->setValue(Parent->RefreshRate() / 60000);
		m_ui->RefreshRateCmb->setCurrentIndex(2);
	}else{ //ms
		m_ui->RefreshRateSpin->setValue(Parent->RefreshRate());
		m_ui->RefreshRateCmb->setCurrentIndex(0);
	} //end if
}

void SettingsDialog::closeEvent(QCloseEvent* event){
        QWidget::closeEvent(event);
	closed();
	delete this;
}
