//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#ifndef FILTERDIALOG_H
#define FILTERDIALOG_H

#include <QtGui/QMainWindow>
#include "torrentdata.h"

namespace Ui {
	class FilterDialog;
}

class FilterDialog : public QMainWindow {
	Q_OBJECT
public:
	FilterDialog(QList<QString> labels, QWidget *parent = 0);
	~FilterDialog();
	void select(QString filter, bool isState, TSortMode mode);

protected:
	void changeEvent(QEvent *e);
	void closeEvent(QCloseEvent*);

private:
	Ui::FilterDialog *m_ui;

signals:
	void closed(QString label, bool isState, TSortMode);
};

#endif // FILTERDIALOG_H
