//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#ifndef TORRENTITEM_H
#define TORRENTITEM_H

#include <QtGui/QFrame>
#include <QMouseEvent>
#include <QTime>
#include "torrentdata.h"
#include "btconnection.h"

namespace Ui {
	class TorrentItem;
}

class TorrentItem : public QFrame {
	Q_OBJECT

public:
	TorrentItem(TorrentData data, QWidget *parent = 0);
	~TorrentItem();
	TorrentData Data(){return data;}
	void setData(TorrentData d){data = d; Reload();}

signals:
	void clicked(TorrentData data, int msec); //argument is duration of click

protected:
	void changeEvent(QEvent *e);
	void mousePressEvent(QMouseEvent*){timer.start();}
	void mouseReleaseEvent(QMouseEvent*);

private:
	Ui::TorrentItem *ui;
	TorrentData data;
	QTime timer;
	BtConnection *connection;

	void Reload();
};

#endif // TORRENTITEM_H
