//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#include "torrentitem.h"
#include "ui_torrentitem.h"
#include "torrentdialog.h"

TorrentItem::TorrentItem(TorrentData data, QWidget *parent) :
	QFrame(parent),	ui(new Ui::TorrentItem), data(data){
	ui->setupUi(this);

	Reload();
}

TorrentItem::~TorrentItem(){
	delete ui;
}

void TorrentItem::changeEvent(QEvent *e){
	QFrame::changeEvent(e);

	switch (e->type()) {
	case QEvent::LanguageChange:
		ui->retranslateUi(this);
		break;
	default:
		break;
	}
}

void TorrentItem::mouseReleaseEvent(QMouseEvent*){
	clicked(data, timer.elapsed());
}

void TorrentItem::Reload(){
	ui->NameLbl->setText(data.Name);
	ui->StatusLbl->setText(data.StatusStr());
	ui->EtaLbl->setText("ETA: " + data.EtaStr());
	ui->DownLbl->setText("Down: " + data.DownSpeedStr());
	ui->UpLbl->setText("Up: " + data.UpSpeedStr());
	ui->Progress->setValue(data.Progress * 1000);

	if(data.ETA == 0) ui->EtaLbl->hide();
	if(data.DownSpeed == 0) ui->DownLbl->hide();
	if(data.UpSpeed == 0) ui->UpLbl->hide();
}

