//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#include <QtGui/QApplication>
#include "mainwindow.h"
#include <qapplication.h>
#include <stdio.h>
#include <stdlib.h>
#include <QFile>
#include <QDateTime>

QFile Log("/var/log/uRemote.log");

void ErrorHandler(QtMsgType, const char *msg){
	printf(msg);
	printf("\n");
	Log.write(msg);
	Log.write("\n");
}

int main(int argc, char *argv[]){
	qDebug(("Running Qt " + QString(qVersion())).toLocal8Bit());

	//delete when size exceeds 100 KB
	if(Log.size() > (1 << 10) * 100) Log.remove();

	Log.open(QIODevice::Append | QIODevice::WriteOnly | QIODevice::Text);
	Log.write(("\n\n" + QDate::currentDate().toString() + "\n").toLocal8Bit());
	qInstallMsgHandler(ErrorHandler);


	QApplication a(argc, argv);
	MainWindow w;
	w.show();
	int ret = a.exec();
	Log.flush();
	Log.close();
	return ret;
}
