#!/usr/bin/python
# -*- coding: utf-8 -*-
import subprocess
import os
import sys
import webbrowser
import time
import dbus

from PyQt4 import QtGui
from PyQt4.uic import loadUi

class MainWindow(QtGui.QMainWindow):
    def __init__(self, parent=None):
        QtGui.QMainWindow.__init__(self,parent)

        self.ui=loadUi("/opt/updateconfigurator/updateconfigurator.ui")
        self.ui.show()
        self.ui.about.triggered.connect(self.about)
        self.ui.craveo.triggered.connect(self.craveobrowser)
        self.ui.close.triggered.connect(self.closefunc)
        self.ui.save.clicked.connect(self.set_value)
        self.ui.slider.valueChanged.connect(self.update_spinbox)
        self.ui.valuebox.valueChanged.connect(self.update_slider)
        self.ui.defaults.clicked.connect(self.restore_default_value)
        self.get_value()
        self.changed=False
        
    def update_spinbox(self, value):
        self.ui.valuebox.setValue(value)
        self.intervall=value         
        self.value=value*24*60
        self.changed=True
    def update_slider(self, value):
        self.ui.slider.setValue(value) 
        self.intervall=value   
        self.value=value*24*60
        self.changed=True
        
    def set_value(self):
        if self.changed==False:
            self.value=1000000
            self.message="Updatecheck deactivated!"         
        else:
            if self.value==0:
                self.value=1000000
                self.message="Updatecheck deactivated!"
            else:    
                self.message="Updateinterval has been modified.The current value is now "+str(self.intervall)+" days"                
        subprocess.Popen(['gconftool','-s','--type','int','/apps/hildon/update-notifier/check_interval', str(self.value)])
        self.show_notification()
        self.get_value()
            
    def get_value(self):     
        time.sleep(0.5)
        currentvalue=subprocess.Popen(['gconftool','-g', '/apps/hildon/update-notifier/check_interval'],stdout=subprocess.PIPE)     
        currentvalue=int(currentvalue.stdout.read())
        if currentvalue==1000000:
            sysvalue="Updates are off"
            self.ui.currentstate.setText(str(sysvalue))
        else:    
            sysvalue=currentvalue/(60*24)
            self.ui.currentstate.setText(str(sysvalue)+" days")
        
    def restore_default_value(self):
        subprocess.Popen(['gconftool','-s','--type','int','/apps/hildon/update-notifier/check_interval','1440'])
        self.message="Values have been restored to default!"  
        self.show_notification()   
        self.get_value()
        
    def craveobrowser(self):
        webbrowser.open("http://www.craveo.de")
        
    def about(self):
        QtGui.QMessageBox.about(self, "Information\n",
                 "With this tool you can change\n"
                 "the period of time, your device\n"
                 "checks for updates.\n"
                 "Value 0 = Updates off!")
        
    def show_notification(self):
        '''
        provides notification dialog
        '''
        bus = dbus.SystemBus()
        iface = dbus.Interface(bus.get_object('org.freedesktop.Notifications',
                                        '/org/freedesktop/Notifications'),
                                        'org.freedesktop.Notifications')
        iface.SystemNoteInfoprint(self.message)
   
       
    def closefunc(self):#Methode zum Schließen des Mainwindows
        sys.exit()
                          
    
app = QtGui.QApplication(sys.argv)
main = MainWindow()
sys.exit(app.exec_())        