/******************************************************************************
 *
 * Copyright (c) 2010 Cláudio F. Gil <claudio.f.gil@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *****************************************************************************/

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QSettings>

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();

    enum ImageInterpolation {
        NoInterpolation = 0,
        BilinearInterpolation,
        BicubicInterpolation
    };

    int fov();
    int focalPointPercent();
    int resultWidth();
    int resultHeight();
    int finalWidth();
    int finalHeight();
    ImageInterpolation interpolation();
    bool invertFinalImage();
    bool equiRectangular();
    QColor equiRectangularFillColor();

public slots:
    void setInnerRadius(qreal radius);
    void setOuterRadius(qreal radius);

protected slots:
    void loadValues();
    void saveValues();
    void updateSizeLabel();
    void updateFinalHeightRatio();
    void updateFinalWidthRatio();

private:
    Ui::SettingsDialog *ui;
    QSettings m_settings;

    qreal m_innerRadius;
    qreal m_outerRadius;
};

#endif // SETTINGSDIALOG_H
