#include "launcher.h"
#include "adapter.h"
#include <QDeclarativeView>

Launcher::Launcher(QObject *parent) :
    QObject(parent)
{
	new LauncherAdaptor(this);

	QDBusConnection connection = QDBusConnection::sessionBus();
	if(!connection.registerObject("/", this))
	{
		qDebug("failed to register dbus object");
		qDebug()<<connection.lastError().message();
	}
	if(!connection.registerService("org.openice.ughost.launcher"))
	{
		qDebug("org.openice.ughost.launcher");
		qDebug()<<connection.lastError().message();
	}
}

void Launcher::LoadQml(QString path)
{
	int childpid = vfork();
	if(!childpid)
	{
		///I'm a newborn child

		QDeclarativeView *view = new QDeclarativeView;
		view->setSource(QUrl(path));
		view->setResizeMode(QDeclarativeView::SizeRootObjectToView);
		view->setGeometry(0,0,800,480);
#if defined(Q_WS_MAEMO_5)
		view->setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif
		view->show();
	}
}
