#ifndef STATIONCHOOSER_H
#define STATIONCHOOSER_H

#include <QDialog>
#include <QFile>
#include <QTextStream>
#include <QSettings>

namespace Ui {
    class StationChooser;
}

class StationChooser : public QDialog
{
    Q_OBJECT
public:
    StationChooser(QWidget *parent = 0);
    ~StationChooser();

    void accept();
    QString getChoice() { return choice; }
    QString getChoiceCRS() { return choiceCRS; }

    int exec();

    static QStringList names;
    static QStringList codes;

    static void loadStations();

public slots:
    void typing(QString);

protected:
    void changeEvent(QEvent *e);

private:
    Ui::StationChooser *ui;
    QString choice;
    QString choiceCRS;
    void reset();
    QSettings settings;
};

#endif // STATIONCHOOSER_H
