#ifndef SERVICEWINDOW_H
#define SERVICEWINDOW_H

#include <QMainWindow>
#include <QtNetwork>
#include <QtXml>
#include <QtXmlPatterns>
#include <src/progressdialog.h>
#include <QMessageBox>
#include "departurewidget.h"

namespace Ui {
    class ServiceWindow;
}

class ServiceWindow : public QMainWindow
{
    Q_OBJECT
public:
    ServiceWindow(QWidget *parent = 0);
    ~ServiceWindow();

    void show(QString serviceID);

protected:
    void changeEvent(QEvent *e);

public slots:
    void readResponse(QNetworkReply*);
    void error(QNetworkReply::NetworkError);
    void updateData() { getData(); }

private:
    Ui::ServiceWindow *ui;

    inline QString queryOne(QXmlQuery & q, QString query);
    inline QStringList queryList(QXmlQuery & q, QString query);

    QNetworkAccessManager * manager;
    ProgressDialog progress;
    QNetworkReply * m_reply;

    QString serviceID;

    void getData();
    QBuffer received;
};

#endif // SERVICEWINDOW_H
