#include "servicewindow.h"
#include "ui_servicewindow.h"

ServiceWindow::ServiceWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::ServiceWindow)
{
    ui->setupUi(this);

    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(readResponse(QNetworkReply*)));

    ui->scrollArea->setProperty("FingerScrollable", true);
}

ServiceWindow::~ServiceWindow()
{
    delete ui;
}

void ServiceWindow::show(QString sID)
{
    serviceID = sID;
    getData();

    QMainWindow::show();
}

void ServiceWindow::getData()
{
    QDomDocument document;

    QDomElement env = document.createElement("soapenv:Envelope");
    env.setAttribute("xmlns:soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
    env.setAttribute("xmlns:typ", "http://thalesgroup.com/RTTI/2007-10-10/ldb/types");

    QDomElement header = document.createElement("soapenv:Header");
    QDomElement body = document.createElement("soapenv:Body");

    QDomElement typ = document.createElement("typ:GetServiceDetailsRequest");

    QDomElement numRows = document.createElement("typ:serviceID");
    numRows.appendChild(document.createTextNode(serviceID));

    document.appendChild(env);
    env.appendChild(header);
        env.appendChild(body);
            body.appendChild(typ);
                typ.appendChild(numRows);

    QString data = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    data.append(document.toString());

    QNetworkRequest networkReq;
    networkReq.setHeader(QNetworkRequest::ContentTypeHeader, QLatin1String("text/xml;charset=utf-8"));
    networkReq.setRawHeader("SOAPAction", "http://thalesgroup.com/RTTI/2008-02-20/ldb/GetServiceDetails");
    networkReq.setUrl(QUrl("http://realtime.nationalrail.co.uk/LDBWS/ldb2.asmx"));

    progress.show();
    m_reply = manager->post(networkReq, data.toUtf8().constData());
    connect(m_reply, SIGNAL(error(QNetworkReply::NetworkError)), this, SLOT(error(QNetworkReply::NetworkError)));
}

void ServiceWindow::error(QNetworkReply::NetworkError error)
{
    Q_UNUSED(error)
    QMessageBox msg;
    msg.setText(QString("Network error: %1").arg(m_reply->errorString()));
    //delete m_reply;
    msg.exec();
}

#define NAMESPACE   "declare namespace t=\"http://thalesgroup.com/RTTI/2007-10-10/ldb/types\";" \
                    "declare function local:if-absent( $arg as item()*, $value as item()* ) as item()* { if (exists($arg)) then $arg else $value } ;"

void ServiceWindow::readResponse(QNetworkReply* reply)
{
    QByteArray in = reply->readAll();

    if(in.size() == 0)
        return;

    received.setData(in);
    received.open(QIODevice::ReadOnly);

    QXmlQuery query;
    query.bindVariable("data", &received);

    QStringList previousNames = queryList(query, "for $x in doc($data)//t:previousCallingPoints/t:callingPointList/t:callingPoint return fn:string(local:if-absent($x/t:locationName, ''))");
    QStringList previousST = queryList(query, "for $x in doc($data)//t:previousCallingPoints/t:callingPointList/t:callingPoint return fn:string(local:if-absent($x/t:st, ''))");
    QStringList previousAT = queryList(query, "for $x in doc($data)//t:previousCallingPoints/t:callingPointList/t:callingPoint return fn:string(local:if-absent($x/t:at, ''))");

    QStringList nextNames = queryList(query, "for $x in doc($data)//t:subsequentCallingPoints/t:callingPointList/t:callingPoint return fn:string(local:if-absent($x/t:locationName, ''))");
    QStringList nextST = queryList(query, "for $x in doc($data)//t:subsequentCallingPoints/t:callingPointList/t:callingPoint return fn:string(local:if-absent($x/t:st, ''))");
    QStringList nextET = queryList(query, "for $x in doc($data)//t:subsequentCallingPoints/t:callingPointList/t:callingPoint return fn:string(local:if-absent($x/t:at, ''))");

    for(int i = 0; i < previousNames.size(); i++)
    {
        DepartureWidget * w = new DepartureWidget(previousST.at(i), previousNames.at(i), previousAT.at(i), "", "");
        ui->scrollArea->widget()->layout()->addWidget(w);
        w->setShowPlatform(false);
    }

    QString name = queryOne(query, "for $x in doc($data)//t:GetServiceDetailsResult return fn:string(local:if-absent($x/t:locationName, ''))");
    QString platform = queryOne(query, "for $x in doc($data)//t:GetServiceDetailsResult return fn:string(local:if-absent($x/t:platform, '-'))");
    QString std = queryOne(query, "for $x in doc($data)//t:GetServiceDetailsResult return fn:string(local:if-absent($x/t:std, '-'))");
    QString etd = queryOne(query, "for $x in doc($data)//t:GetServiceDetailsResult return fn:string(local:if-absent($x/t:etd, '-'))");

    DepartureWidget * w = new DepartureWidget(std, name, etd, platform, "");
    ui->scrollArea->widget()->layout()->addWidget(w);
    //ui->scrollAreaWidgetContents->layout()->addWidget(w);

    for(int i = 0; i < nextNames.size(); i++)
    {
        DepartureWidget * w = new DepartureWidget(nextST.at(i), nextNames.at(i), nextET.at(i), "", "");
        ui->scrollArea->widget()->layout()->addWidget(w);
        w->setShowPlatform(false);
    }

    progress.accept();
    //delete reply;
    received.close();
}

QString ServiceWindow::queryOne(QXmlQuery & q, QString query)
{
    QStringList output;
    output.clear();
    q.setQuery(query.prepend(NAMESPACE));
    q.evaluateTo(&output);
    return (output.size() == 0) ? QString() : output.at(0);
}

QStringList ServiceWindow::queryList(QXmlQuery & q, QString query)
{
    QStringList output;
    output.clear();
    q.setQuery(query.prepend(NAMESPACE));
    q.evaluateTo(&output);
    return output;
}

void ServiceWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
