#include "favouritestations.h"
#include "ui_favouritestations.h"

FavouriteStations::FavouriteStations(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FavouriteStations)
{
    ui->setupUi(this);
}

void FavouriteStations::addFavourite()
{
    StationChooser chooser;

    if(chooser.exec() == QDialog::Accepted)
    {
        QListWidgetItem * li = new QListWidgetItem(chooser.getChoice());
        li->setData(Qt::UserRole, chooser.getChoiceCRS());
        ui->listWidget->addItem(li);
        ui->listWidget->sortItems();
    }
}

void FavouriteStations::selectionChanged()
{
    ui->delete_button->setEnabled(true);
}

void FavouriteStations::deleteFavourite()
{
    if(ui->listWidget->currentRow() != -1)
        ui->listWidget->takeItem(ui->listWidget->currentRow());
}

void FavouriteStations::save()
{
    QStringList nameList;
    QStringList codeList;

    for(int i = 0; i < ui->listWidget->count(); i++)
    {
        nameList << ui->listWidget->item(i)->text();
        codeList << ui->listWidget->item(i)->data(Qt::UserRole).toString();
    }

    settings.setValue(names, nameList);
    settings.setValue(codes, codeList);
}

void FavouriteStations::accept()
{
    save();
    QDialog::accept();
}

void FavouriteStations::reject()
{
    save();
    QDialog::reject();
}

int FavouriteStations::exec(QString stationNames, QString stationCodes)
{
    ui->listWidget->clear();

    names = stationNames;
    codes = stationCodes;

    QVariant nameV = settings.value(names, QVariant());
    QVariant codeV = settings.value(codes, QVariant());

    if(nameV != QVariant())
    {
        QStringList nameList = nameV.toStringList();
        QStringList codeList = codeV.toStringList();

        for(int i = 0; i < nameList.size(); i++)
        {
            QListWidgetItem * wi = new QListWidgetItem(nameList.at(i));
            wi->setData(Qt::UserRole, codeList.at(i));

            ui->listWidget->addItem(wi);
        }
    }

    ui->listWidget->sortItems();
    ui->listWidget->setCurrentRow(0);

    return QDialog::exec();
}

FavouriteStations::~FavouriteStations()
{
    delete ui;
}

void FavouriteStations::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
