/*
 *   National Rail Live Departure boards software for the Maemo platform.
 *   Copyright (C) 2010 Stewart Holmes
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Contact: stewart@stewartholmes.com
 */

#ifndef DEPARTUREWIDGET_H
#define DEPARTUREWIDGET_H

#include <QWidget>

namespace Ui {
    class DepartureWidget;
}

class DepartureWidget : public QWidget {
    Q_OBJECT
public:
    explicit DepartureWidget(QString time, QString dest, QString late, QString platform, QString id, QWidget *parent = 0);
    ~DepartureWidget();

    void setHighlighted(bool h);

    QString getServiceID() { return m_id; }

    void setShowPlatform(bool b);

signals:
    void clicked();

protected:
    void changeEvent(QEvent *e);

    void mousePressEvent ( QMouseEvent * event ) { Q_UNUSED(event) emit clicked(); }

private:
    Ui::DepartureWidget *ui;
    QString m_id;
};

#endif // DEPARTUREWIDGET_H
