/*
 *   National Rail Live Departure boards software for the Maemo platform.
 *   Copyright (C) 2010 Stewart Holmes
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Contact: stewart@stewartholmes.com
 */

#include "departurewidget.h"
#include "ui_departurewidget.h"

DepartureWidget::DepartureWidget(QString time, QString dest, QString late, QString platform, QString id, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::DepartureWidget)
{
    ui->setupUi(this);

    ui->time->setText(time);
    ui->destination->setText(dest);
    ui->status->setText(late);
    ui->platform->setText(platform);
    m_id = id;
}

void DepartureWidget::setShowPlatform(bool b)
{
    ui->platform->setVisible(b);
    ui->platformlabel->setVisible(b);
}

void DepartureWidget::setHighlighted(bool h)
{
    ui->frame->setAutoFillBackground(true);

    if(h)
        ui->frame->setBackgroundRole(QPalette::Highlight);
    else
        ui->frame->setBackgroundRole(QPalette::Background);
}

DepartureWidget::~DepartureWidget()
{
    delete ui;
}

void DepartureWidget::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
