#ifndef DEPARTUREBOARD_H
#define DEPARTUREBOARD_H

#include <QMainWindow>

#include <QtNetwork>
#include <QtXml>
#include <QtXmlPatterns>
#include <src/progressdialog.h>
#include <QMessageBox>
#include <QStandardItemModel>
#include <src/servicewindow.h>
#include <src/departurewidget.h>

namespace Ui {
    class DepartureBoard;
}

class DepartureBoard : public QMainWindow {
    Q_OBJECT
public:
    DepartureBoard(QWidget *parent = 0);
    ~DepartureBoard();

    void getData();

    void show(QString fromCode);

protected:
    void changeEvent(QEvent *e);

public slots:
    void readResponse(QNetworkReply*);
    void error(QNetworkReply::NetworkError);
    void updateData() { getData(); }

    void departureClicked();

private:
    Ui::DepartureBoard *ui;

    QNetworkAccessManager * manager;
    ProgressDialog progress;
    QNetworkReply * m_reply;

    QBuffer received;

    QString from;
    QString to;

    inline QString queryOne(QXmlQuery & q, QString query);
    inline QStringList queryList(QXmlQuery & q, QString query);

    QTimer updateTimer;

    QStringList serviceID;

    QVector<DepartureWidget *> departureWidgets;
};

#endif // DEPARTUREBOARD_H
