#include "departureboard.h"
#include "ui_departureboard.h"

DepartureBoard::DepartureBoard(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::DepartureBoard)
{
    ui->setupUi(this);

    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(readResponse(QNetworkReply*)));

    //connect(&updateTimer, SIGNAL(timeout()), this, SLOT(updateData()));
    //updateTimer.setInterval(1000 * 60);
    //updateTimer.start();
    ui->scrollArea->setProperty("FingerScrollable", true);
}

void DepartureBoard::show(QString fromCode)
{
    from = fromCode;

    getData();
}

void DepartureBoard::getData()
{
    QDomDocument document;

    QDomElement env = document.createElement("soapenv:Envelope");
    env.setAttribute("xmlns:soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
    env.setAttribute("xmlns:typ", "http://thalesgroup.com/RTTI/2008-02-20/ldb/types");

    QDomElement header = document.createElement("soapenv:Header");
    QDomElement body = document.createElement("soapenv:Body");

    QDomElement typ = document.createElement("typ:GetDepartureBoardRequest");

    QDomElement numRows = document.createElement("typ:numRows");
    numRows.appendChild(document.createTextNode("20"));
    QDomElement crs = document.createElement("typ:crs");
    crs.appendChild(document.createTextNode(from));
    QDomElement filterCrs = document.createElement("typ:filterCrs");
    filterCrs.appendChild(document.createTextNode(to));
    QDomElement filterType = document.createElement("typ:filterType");
    filterType.appendChild(document.createTextNode("to"));
    QDomElement timeOffset = document.createElement("typ:timeOffset");
    timeOffset.appendChild(document.createTextNode("0"));

    document.appendChild(env);
        env.appendChild(header);
        env.appendChild(body);
            body.appendChild(typ);
                typ.appendChild(numRows);
                typ.appendChild(crs);
                typ.appendChild(filterCrs);
                typ.appendChild(filterType);
                typ.appendChild(timeOffset);

    QString data = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    data.append(document.toString());

    QNetworkRequest networkReq;
    networkReq.setHeader(QNetworkRequest::ContentTypeHeader, QLatin1String("text/xml;charset=utf-8"));
    networkReq.setRawHeader("SOAPAction", "http://thalesgroup.com/RTTI/2008-02-20/ldb/GetDepartureBoard");
    networkReq.setUrl(QUrl("http://realtime.nationalrail.co.uk/LDBWS/ldb2.asmx"));

    progress.show();
    m_reply = manager->post(networkReq, data.toUtf8().constData());
    connect(m_reply, SIGNAL(error(QNetworkReply::NetworkError)), this, SLOT(error(QNetworkReply::NetworkError)));
}

void DepartureBoard::error(QNetworkReply::NetworkError error)
{
    Q_UNUSED(error)
    QMessageBox msg;
    msg.setText(QString("Network error: %1").arg(m_reply->errorString()));
    msg.exec();
}

#define NAMESPACE   "declare namespace t=\"http://thalesgroup.com/RTTI/2007-10-10/ldb/types\";" \
                    "declare function local:if-absent( $arg as item()*, $value as item()* ) as item()* { if (exists($arg)) then $arg else $value } ;"

void DepartureBoard::readResponse(QNetworkReply* reply)
{
    QByteArray in = reply->readAll();
    received.setData(in);
    received.open(QIODevice::ReadOnly);

    if(in.length() == 0)
    {
        QMessageBox * msg = new QMessageBox();
        msg->setText("Error");
        msg->exec();
        progress.hide();
        return;
    }

    QXmlQuery query;
    query.bindVariable("data", &received);

    QString name = queryOne(query, "for $x in doc($data)//t:GetDepartureBoardResult/t:locationName/text() return fn:string($x)");
    ui->label_name->setText(name);

    QString time = queryOne(query, "for $x in doc($data)//t:generatedAt/text() return fn:string($x)");
    time.mid(time.indexOf('T') + 1, 8);

    setWindowTitle(time.mid(time.indexOf('T') + 1, 8).prepend("Last updated: "));

    QStringList serviceFrom = queryList(query, "for $x in doc($data)//t:trainServices//t:origin//t:locationName/text() return fn:string($x)");
    QStringList serviceTo = queryList(query, "for $x in doc($data)//t:trainServices//t:destination//t:locationName/text() return fn:string($x)");
    QStringList serviceVia = queryList(query, "for $x in doc($data)//t:trainServices/t:service/t:destination/t:location return string(local:if-absent($x/t:via, ''))");

    QStringList std = queryList(query, "for $x in doc($data)//t:trainServices//t:std/text() return fn:string($x)");
    QStringList etd = queryList(query, "for $x in doc($data)//t:trainServices//t:etd/text() return fn:string($x)");
    QStringList platform = queryList(query, "for $x in doc($data)//t:trainServices/t:service return string(local:if-absent($x/t:platform, '-'))");
    QStringList op = queryList(query, "for $x in doc($data)//t:trainServices//t:operator/text() return fn:string($x)");
    serviceID = queryList(query, "for $x in doc($data)//t:trainServices//t:serviceID/text() return fn:string($x)");

    for(int i = 0; i < serviceFrom.size(); i++)
    {
        QString to = QString("%1 %2").arg(serviceTo.at(i)).arg(serviceVia.at(i));
        DepartureWidget * w = new DepartureWidget(std.at(i), to, etd.at(i), platform.at(i), serviceID.at(i), ui->departures);
        departureWidgets.append(w);
        w->setObjectName(QString("%1").arg(i));
        connect(w, SIGNAL(clicked()), this, SLOT(departureClicked()));
        ui->departures->layout()->addWidget(w);
    }

    progress.accept();
    //TODO: NEED TO DO THIS SOMEWHERE!
    //delete reply;
    received.close();
    QMainWindow::show();
}

void DepartureBoard::departureClicked()
{
    int i = sender()->objectName().toInt();

    QString id = departureWidgets.at(i)->getServiceID();

    ServiceWindow * w = new ServiceWindow();
    w->show(id);
}

QString DepartureBoard::queryOne(QXmlQuery & q, QString query)
{
    QStringList output;
    output.clear();
    q.setQuery(query.prepend(NAMESPACE));
    q.evaluateTo(&output);
    return (output.size() == 0) ? QString() : output.at(0);
}

QStringList DepartureBoard::queryList(QXmlQuery & q, QString query)
{
    QStringList output;
    output.clear();
    q.setQuery(query.prepend(NAMESPACE));
    q.evaluateTo(&output);
    return output;
}

DepartureBoard::~DepartureBoard()
{
    delete ui;
    delete manager;
}

void DepartureBoard::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
