#ifndef CHOOSER_H
#define CHOOSER_H

#include <QMainWindow>
#include <QDesktopServices>
#include <QUrl>
#include <QPushButton>
#include "src/stationchooser.h"
#include "src/favouritestations.h"
#include "src/departureboard.h"

namespace Ui {
    class Chooser;
}

class Chooser : public QMainWindow {
    Q_OBJECT
public:
    Chooser(QWidget *parent = 0);
    ~Chooser();

public slots:
    void launchPlanner();

    void stationSelected();
    void editFavouriteDepartures();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::Chooser *ui;

    QPushButton * addStationButton(QString name, QString crs);
    void updateStationButtons();

    QSettings settings;

    FavouriteStations favouriteStations;
    QVector<QPushButton *> stationButtons;

    DepartureBoard depatureBoard;
};

#endif // CHOOSER_H
