#include "chooser.h"
#include "ui_chooser.h"

Chooser::Chooser(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::Chooser)
{
    ui->setupUi(this);
    ui->scrollArea->setProperty("FingerScrollable", true);
    updateStationButtons();
}

void Chooser::updateStationButtons()
{
    for(int i = 0; i < stationButtons.size(); i++)
        delete stationButtons.at(i);

    stationButtons.clear();

    QVariant favourites = settings.value("FavouriteDepartureBoards", QVariant());
    QVariant favouritesCRS = settings.value("FavouriteDepartureBoardsCRS", QVariant());

    if(favourites != QVariant())
    {
        QStringList list = favourites.toStringList();
        QStringList listCRS = favouritesCRS.toStringList();

        for(int i = 0; i < list.size(); i++)
        {
            addStationButton(list.at(i), listCRS.at(i));
        }
    }

    QPushButton * b = new QPushButton("Edit Favourites...");
    stationButtons.append(b);
    ui->favourites_widget->layout()->addWidget(b);
    b->setIcon(QIcon(":/icons/folder.png"));
    connect(b, SIGNAL(clicked()), this, SLOT(editFavouriteDepartures()));
}

void Chooser::editFavouriteDepartures()
{
    favouriteStations.exec("FavouriteDepartureBoards", "FavouriteDepartureBoardsCRS");
    updateStationButtons();
}

QPushButton * Chooser::addStationButton(QString name, QString crs)
{
    QPushButton * b = new QPushButton(name);
    stationButtons.append(b);
    b->setObjectName(crs);
    connect(b, SIGNAL(clicked()), this, SLOT(stationSelected()));
    ui->favourites_widget->layout()->addWidget(b);
    return b;
}

void Chooser::stationSelected()
{
    this->depatureBoard.show(sender()->objectName());
}

Chooser::~Chooser()
{
    delete ui;
}

void Chooser::launchPlanner()
{
    QDesktopServices::openUrl(QUrl("http://ojp.nationalrail.co.uk/en/s/planjourney/query"));
    exit(0);
}

void Chooser::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
