#include "src/stationchooser.h"
#include "ui_stationchooser.h"

QStringList StationChooser::names;
QStringList StationChooser::codes;

StationChooser::StationChooser(QWidget *parent) :
    QDialog(parent), ui(new Ui::StationChooser)
{
    ui->setupUi(this);
    if(StationChooser::names.size() == 0)
    {
        StationChooser::loadStations();
    }
}

StationChooser::~StationChooser()
{
    delete ui;
}

int StationChooser::exec()
{
    reset();
    return QDialog::exec();
}

void StationChooser::reset()
{
    ui->lineEdit->setText("");
    typing("");
}

void StationChooser::loadStations()
{
    QFile file(":/stations/stations.txt");
    file.open(QIODevice::ReadOnly | QIODevice::Text);

    QTextStream stream(&file);

    while(!stream.atEnd())
    {
        QString in = file.readLine();
        QStringList l = in.trimmed().split(",");

        StationChooser::names << QString("%1 (%2)").arg(l.at(0)).arg(l.at(1));
        StationChooser::codes << l.at(1);
    }

    file.close();
}

void StationChooser::accept()
{
    choice = ui->listWidget->currentItem()->text();
    choiceCRS = ui->listWidget->currentItem()->data(Qt::UserRole).toString();

    QDialog::accept();
}

void StationChooser::typing(QString text)
{
    ui->listWidget->clear();

    if(text == QString())
    {
        for(int i = 0; i < StationChooser::names.size(); i++)
        {
            QListWidgetItem * li = new QListWidgetItem(StationChooser::names.at(i));
            li->setData(Qt::UserRole, StationChooser::codes.at(i));

            ui->listWidget->addItem(li);
        }
    }
    else
    {
        for(int i = 0; i < StationChooser::names.size(); i++)
        {
            if(StationChooser::names.at(i).contains(text, Qt::CaseInsensitive))
            {
                QListWidgetItem * li = new QListWidgetItem(StationChooser::names.at(i));
                li->setData(Qt::UserRole, StationChooser::codes.at(i));
                ui->listWidget->addItem(li);
            }
        }
    }

    ui->listWidget->setCurrentRow(0);
}

void StationChooser::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
