#ifndef DEPARTUREBOARD_H
#define DEPARTUREBOARD_H

#include <QMainWindow>

#include <QtNetwork>
#include <QtXml>
#include <QtXmlPatterns>
#include <QtGui>
#include <src/servicewindow.h>
#include <src/departurewidget.h>

namespace Ui {
    class DepartureBoard;
}

class DepartureBoard : public QMainWindow {
    Q_OBJECT
public:
    DepartureBoard(QWidget *parent = 0);
    ~DepartureBoard();

    void sendRequest(); //Send the network request
    void show(QString fromCode); //Show the departure board for the relevant station

protected:
    void changeEvent(QEvent *e);

public slots:
    void readResponse(QNetworkReply*); //Read the network response & extract the required data
    void networkError(QNetworkReply::NetworkError);

    void departureClicked(); //Show the service window for the selected train

    void downloadProgress(qint64 rec, qint64 total);
    void uploadProgress(qint64 rec, qint64 total);

    void ensureConnection(); //Used to wait for a network connection
    void cancel(); //Cancel the current request for the departure board

private:
    Ui::DepartureBoard *ui;

    QNetworkAccessManager * manager;
    QNetworkReply * m_reply;

    ServiceWindow * serviceWindow;

    QBuffer received;
    QString from;

    void setupDialog();
    void setupRequest();

    QNetworkRequest request;
    QString requestData;

    inline QString queryOne(QXmlQuery & q, QString query);
    inline QStringList queryList(QXmlQuery & q, QString query);

    QStringList serviceID; //The service IDs for

    QVector<DepartureWidget *> departureWidgets;

    QDialog * dialog; //Dialog with progress bar for the network request
        QLayout * layout;
            QProgressBar * progress;
            QPushButton * cancelButton;

    bool errorFlag;
    bool firstTime;
};

#endif // DEPARTUREBOARD_H
