#ifndef CHOOSER_H
#define CHOOSER_H

#include <QMainWindow>
#include <QDesktopServices>
#include <QUrl>
#include <QPushButton>
#include "src/stationchooser.h"
#include "src/favouritestations.h"
#include "src/departureboard.h"
#include <QDBusConnection>

namespace Ui {
    class Chooser;
}

class Chooser : public QMainWindow {
    Q_OBJECT
public:
    Chooser(QWidget *parent = 0);
    ~Chooser();

public slots:
    void launchPlanner(); //Launches the journey planner
    void stationSelected(); //Handles when a station departure board button is clicked
    void editFavouriteDepartures(); //Handles when the user chooses to edit their favourite station
    void chooseStation();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::Chooser *ui;

    QPushButton * addStationButton(QString name, QString crs);
    void updateStationButtons();

    QSettings settings;

    FavouriteStations favouriteStations;
    QVector<QPushButton *> stationButtons;

    DepartureBoard * departureBoard;
};

#endif // CHOOSER_H
