

class Request(QObject):

    cacheUpdated = Signal()
    requestFailed = Signal(str)

    def __init__(self, parent, session, path, params={}):
        super(Request, self).__init(parent)
        self.__session = session
        self.__path = path
        self.__params = params

    def get(self):
        pass

    def update_cache(self):
        pass

    def params(self):
        return self.__params

    def path(self):
        return self.__path


class Search(Request):

    __path = "/venues/search"

    def __init__(self, parent, session, query, ll, category, limit):
        params = {'query': query, 'll': ll, 'intent': "checkin", 'categoryId': category, 'limit': limit}
        super(Search, self).__init__(parent, session, self.__path, params)

    def get(self):
        pass

    def update_cache(self):
        pass


class Visited(Request):

    __path = "/users/self/venuehistory"

    def __init__(self, parent, session):
        super(Visited, self).__init__(parent, session, self.__path)
        # return self.__build_venue_array(response['response']['venues']['items'])

    def get(self):
        pass

    def update_cache(self):
        pass
