# Copyright (c) 2012 Hugo Osvaldo Barrera <hugo@osvaldobarrera.com.ar>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

from PySide.QtGui import QDialog, QVBoxLayout, QLabel
from PySide.QtMaemo5 import QMaemo5ValueButton

class SignalEmittingValueButton(QMaemo5ValueButton):
	def __init__(self, text, callback, parent):
		super(SignalEmittingValueButton, self).__init__(text, parent)
		self.callback = callback

	def setValueText(self, text):
		super(SignalEmittingValueButton, self).setValueText(text)
		self.callback(self.pickSelector().currentIndex())

class WaitingDialog(QDialog):
	def __init__(self, parent = None):
		super(WaitingDialog, self).__init__(parent)
		layout = QVBoxLayout()
		layout.addWidget(QLabel("Please wait; fetching data from foursquare..."))
		self.setLayout(layout)
		self.setWindowTitle("Please wait")