
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <dbus/dbus-glib.h>

#define OFFSET_X (-100)
#define OFFSET_Y (-80)

typedef struct {
    GtkWindow *window;
    HildonPannableArea *pannable;
    GtkImage *image;
    HildonAppMenu *appmenu;
    GtkButton *auskunft;
} UBahn;

gboolean center_view(gpointer data)
{
    UBahn *ubahn = (UBahn*)data;

    gtk_image_set_from_file(ubahn->image, "/opt/ubahn/wien.png");
    GdkPixbuf *pixbuf = gtk_image_get_pixbuf(ubahn->image);

    while (gtk_events_pending()) gtk_main_iteration();

    hildon_pannable_area_scroll_to(ubahn->pannable,
                                   gdk_pixbuf_get_width(pixbuf)/2+OFFSET_X,
                                   gdk_pixbuf_get_height(pixbuf)/2+OFFSET_Y);

    hildon_gtk_window_set_progress_indicator(ubahn->window, 0);

    return FALSE;
}

static void
open_webbrowser(const gchar* url)
{
    DBusGConnection *connection;
    GError *error = NULL;
    DBusGProxy *proxy;

    connection = dbus_g_bus_get(DBUS_BUS_SESSION, &error);
    if (connection == NULL) {
        /* FIXME: Should show error with URL to user */
        g_error_free(error);
        return;
    }

    proxy = dbus_g_proxy_new_for_name(connection,
            "com.nokia.osso_browser",
            "/com/nokia/osso_browser/request",
            "com.nokia.osso_browser");

    if (!dbus_g_proxy_call(proxy, "load_url", &error, G_TYPE_STRING, url,
                G_TYPE_INVALID, G_TYPE_INVALID)) {
        /* FIXME: Should show error with URL to user */
        g_error_free(error);
    }
}


void on_auskunft(GtkWidget *widget, gpointer data)
{
    open_webbrowser("http://efa.vor.at/wvb/XSLT_TRIP_REQUEST2?language=de");
}

int main(int argc, char **argv)
{
    gtk_init(&argc, &argv);
    UBahn ubahn = {0};

    ubahn.window = GTK_WINDOW(hildon_window_new());
    gtk_window_set_title(ubahn.window, "U-Bahn-Netz Wien");
    hildon_gtk_window_set_progress_indicator(ubahn.window, 1);
    g_signal_connect(G_OBJECT(ubahn.window),
                     "destroy",
                     G_CALLBACK(gtk_main_quit),
                     NULL);

    ubahn.appmenu = HILDON_APP_MENU(hildon_app_menu_new());
    ubahn.auskunft = GTK_BUTTON(gtk_button_new_with_label("Fahrplanauskunft"));
    g_signal_connect(G_OBJECT(ubahn.auskunft),
                     "clicked",
                     G_CALLBACK(on_auskunft),
                     NULL);
    hildon_app_menu_append(ubahn.appmenu, GTK_BUTTON(ubahn.auskunft));
    gtk_widget_show_all(GTK_WIDGET(ubahn.appmenu));
    hildon_window_set_app_menu(HILDON_WINDOW(ubahn.window), ubahn.appmenu);

    ubahn.pannable = HILDON_PANNABLE_AREA(hildon_pannable_area_new());
    g_object_set(G_OBJECT(ubahn.pannable),
                 "mov-mode",
                 HILDON_MOVEMENT_MODE_BOTH,
                 NULL);

    gtk_container_add(GTK_CONTAINER(ubahn.window),
                      GTK_WIDGET(ubahn.pannable));

    ubahn.image = GTK_IMAGE(gtk_image_new());
    hildon_pannable_area_add_with_viewport(ubahn.pannable,
            GTK_WIDGET(ubahn.image));

    gtk_widget_show_all(GTK_WIDGET(ubahn.window));

    g_idle_add(&center_view, &ubahn);

    gtk_main();
    return 0;
}

