#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include "config.h"
#include "menu.h"

#include<SDL.h>
#include <SDL_image.h>
#include "sysconfig.h"
#include "sysdeps.h"
#include "uae.h"
#include "options.h"
#include "zfile.h"
#include "sound.h"
#include <png.h>
#include "msg.h"
#include "fade.h"

#include <SDL_gfxPrimitives.h>
#ifndef WIZ
#include <SDL_gp2x.h>
#endif

extern int mainMenu_drives;
//drive_prefs_struct  *real_changed=0;
//drive_prefs_struct  *changed_df=0;
extern char uae4all_image_file0[128];

#ifdef DREAMCAST
#define VIDEO_FLAGS_INIT SDL_HWSURFACE|SDL_FULLSCREEN
#endif

#ifdef GP2X
#define VIDEO_FLAGS_INIT SDL_SWSURFACE|SDL_FULLSCREEN
#endif

#if ! defined (DREAMCAST) && ! defined (GP2X)
#define VIDEO_FLAGS_INIT SDL_HWSURFACE
#endif

#ifdef DOUBLEBUFFER
#define VIDEO_FLAGS VIDEO_FLAGS_INIT | SDL_DOUBLEBUF
#else
#define VIDEO_FLAGS VIDEO_FLAGS_INIT
#endif

SDL_Surface *text_screen=NULL, *text_image, *text_background, *text_window_background, *window_screen;

static Uint32 menu_inv_color=0, menu_win0_color=0, menu_win1_color=0;
static Uint32 menu_barra0_color=0, menu_barra1_color=0;
static Uint32 menu_win0_color_base=0, menu_win1_color_base=0;

void write_text_pos(int x, int y, char * str);
void write_num(int x, int y, int v);
int menu_msg_pos=330;
int menu_moving=1;
Uint32 menu_msg_time=0x12345678;
int skipintro=0;

#ifdef DREAMCAST
extern int __sdl_dc_emulate_keyboard;
#endif
/*
void setupDrives(int num)
{
	
	if (prefs_drives) delete prefs_drives;
	if (uae4all_image_file) delete uae4all_image_file;
	if (changed_drives) delete changed_drives;
	if (realchanged_drives) delete realchanged_drives;
	
	prefs_drives=new drive_prefs_struct[num];	
	uae4all_image_file=new drive_prefs_struct[num];
	realchanged_drives= new int[num];
	changed_drives=new drive_prefs_struct[num];

}
*/
extern char launchDir[300];

static void obten_colores(void)
{
	FILE *f=fopen(DATA_PREFIX "colors.txt", "rt");
	if (f)
	{
		Uint32 r,g,b;
		fscanf(f,"menu_inv_color=0x%X,0x%X,0x%X\n",&r,&g,&b);
		menu_inv_color=SDL_MapRGB(text_screen->format,r,g,b);
		fscanf(f,"menu_win0_color=0x%X,0x%X,0x%X\n",&r,&g,&b);
		menu_win0_color=SDL_MapRGB(text_screen->format,r,g,b);
		fscanf(f,"menu_win1_color=0x%X,0x%X,0x%X\n",&r,&g,&b);
		menu_win1_color=SDL_MapRGB(text_screen->format,r,g,b);
		fscanf(f,"menu_barra0_color=0x%X,0x%X,0x%X\n",&r,&g,&b);
		menu_barra0_color=SDL_MapRGB(text_screen->format,r,g,b);
		fscanf(f,"menu_barra1_color=0x%X,0x%X,0x%X\n",&r,&g,&b);
		menu_barra1_color=SDL_MapRGB(text_screen->format,r,g,b);
		fclose(f);
	}
	else
	{
		menu_inv_color=SDL_MapRGB(text_screen->format, 0x20, 0x20, 0x40);
		menu_win0_color=SDL_MapRGB(text_screen->format, 0x10, 0x08, 0x08);
		menu_win1_color=SDL_MapRGB(text_screen->format, 0x20, 0x10, 0x10);
		menu_barra0_color=SDL_MapRGB(text_screen->format, 0x30, 0x20, 0x20);
		menu_barra1_color=SDL_MapRGB(text_screen->format, 0x50, 0x40, 0x40);
	}
	menu_win0_color_base=menu_win0_color;
	menu_win1_color_base=menu_win1_color;
}
#define  systemRedShift      (prSDLScreen->format->Rshift)
#define  systemGreenShift    (prSDLScreen->format->Gshift)
#define  systemBlueShift     (prSDLScreen->format->Bshift)
#define  systemRedMask       (prSDLScreen->format->Rmask)
#define  systemGreenMask     (prSDLScreen->format->Gmask)
#define  systemBlueMask      (prSDLScreen->format->Bmask)
int save_png(SDL_Surface* surface,char *path)
{
  int w = surface->w;
  int h = surface->h;
  //char path[300];
  unsigned char * pix = (unsigned char *)surface->pixels;
  unsigned char writeBuffer[512 * 3];
  FILE *f  = fopen(path,"wb");
  if(!f) return 0;
  png_structp png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING,
                                                NULL,
                                                NULL,
                                                NULL);
  if(!png_ptr) {
    fclose(f);
    return 0;
  }

  png_infop info_ptr = png_create_info_struct(png_ptr);

  if(!info_ptr) {
    png_destroy_write_struct(&png_ptr,NULL);
    fclose(f);
    return 0;
  }

  png_init_io(png_ptr,f);

  png_set_IHDR(png_ptr,
               info_ptr,
               w,
               h,
               8,
               PNG_COLOR_TYPE_RGB,
               PNG_INTERLACE_NONE,
               PNG_COMPRESSION_TYPE_DEFAULT,
               PNG_FILTER_TYPE_DEFAULT);

  png_write_info(png_ptr,info_ptr);

  unsigned char *b = writeBuffer;

  int sizeX = w;
  int sizeY = h;
  int y;
  int x;

unsigned short *p = (unsigned short *)pix;
for(y = 0; y < sizeY; y++) 
{
   for(x = 0; x < sizeX; x++) 
   {
     unsigned short v = p[x];

     *b++ = ((v & systemRedMask  ) >> systemRedShift  ) << 3; // R
     *b++ = ((v & systemGreenMask) >> systemGreenShift) << 2; // G 
     *b++ = ((v & systemBlueMask ) >> systemBlueShift ) << 3; // B
   }
   p += surface->pitch / 2;
   png_write_row(png_ptr,writeBuffer);
   b = writeBuffer;
}

  png_write_end(png_ptr, info_ptr);

  png_destroy_write_struct(&png_ptr, &info_ptr);

  fclose(f);
  return 1;
}

int save_thumb(int code,char *path)
{
	 SDL_Surface *thumb_screen;
	 int scaling,xstart,ystart,xend,yend,w,h;

if (code==SCREENSHOT){
		scaling=1;
		xstart=0;
		ystart=0;
		yend=prSDLScreen->h;
		xend=prSDLScreen->w;
		w=prSDLScreen->w;
		h=prSDLScreen->h;
	}
	else { 
		scaling=7;
		xstart=48;
		ystart=8;
		xend=320-48;
		yend=240-8;
		w=32;
		h=32;
	}
	thumb_screen=SDL_CreateRGBSurface(prSDLScreen->flags,w,h,prSDLScreen->format->BitsPerPixel,prSDLScreen->format->Rmask,prSDLScreen->format->Gmask,prSDLScreen->format->Bmask,prSDLScreen->format->Amask);

int x;
int y=ystart;
 unsigned short * src_pixel = (unsigned short*)prSDLScreen->pixels;
 unsigned short * dst_pixel = (unsigned short*)thumb_screen->pixels;
 unsigned short * scan_src_pixel = 0;
 /*printf("Save thumb with startx %d - starty %d - endx %d - endy %d  w %d - h %d\n",xstart,xend,ystart,yend,w,h); 
 printf("Thumb screen width %d \n",prSDLScreen->w); 
 */
 for (y=ystart; y < yend; y+=scaling) {
	scan_src_pixel = src_pixel + (prSDLScreen->w * y);
    for (x = xstart; x < xend; x+=scaling)*dst_pixel++ = scan_src_pixel[x];
 }
	int ret=save_png(thumb_screen,path);
 	printf("SAVED \n");
	SDL_FreeSurface(thumb_screen);
	return ret;
 }


void menu_raise(void)
{
	int i;
	for(i=80;i>=0;i-=16)
	{
#if !defined(NO_SOUND) && defined(MENU_MUSIC)
		Mix_VolumeMusic(MUSIC_VOLUME-(i<<1));
#endif
		text_draw_background();
		fade16(text_screen,i);
		text_flip();
		SDL_Delay(10);
	}
}

void menu_unraise(void)
{
	int i;
	for(i=0;i<=80;i+=16)
	{
#if !defined(NO_SOUND) && defined(MENU_MUSIC)
		Mix_VolumeMusic(MUSIC_VOLUME-(i<<1));
#endif
		text_draw_background();
		fade16(text_screen,i);
		text_flip();
		SDL_Delay(10);
	}
}

static void text_draw_menu_msg()
{
	write_text_pos(menu_msg_pos,0,menu_msg);
	if (menu_msg_pos<MAX_SCROLL_MSG)
		menu_msg_pos=330;
	else
		menu_msg_pos--;
}


static void update_window_color(void)
{
	static int cambio=0;
	static int spin=0;

	Uint8 r,g,b;
	int cambio2=cambio>>3;
	SDL_GetRGB(menu_win0_color_base,text_screen->format,&r,&g,&b);
	if (((int)r)-cambio2>0) r-=cambio2;
	else r=0;
	if (((int)g)-cambio2>0) g-=cambio2;
	else g=0;
	if (((int)b)-cambio2>0) b-=cambio2;
	else b=0;
	menu_win0_color=SDL_MapRGB(text_screen->format,r,g,b);
	SDL_GetRGB(menu_win1_color_base,text_screen->format,&r,&g,&b);
	if (((int)r)-cambio>0) r-=cambio;
	else r=0;
	if (((int)g)-cambio>0) g-=cambio;
	else g=0;
	if (((int)b)-cambio>0) b-=cambio;
	else b=0;
	menu_win1_color=SDL_MapRGB(text_screen->format,r,g,b);
	if (spin)
	{
		if (cambio<=0) spin=0;
		else cambio-=2;

	}
	else
	{
		if (cambio>=24) spin=1;
		else cambio+=2;
	}
}

void text_draw_background()
{
	static int pos_x=12345678;
	static int pos_y=12345678;
	SDL_Rect r;
	int i,j;
	int w=text_screen->w+text_background->w-1;
	int h=text_screen->h+text_background->h-1;

	if (menu_moving)
	{
		if (pos_x>=0) pos_x=-text_screen->w;
		else pos_x++;
		if (pos_y>=0) pos_y=-text_screen->h;
		else pos_y++;
	}

	for(i=pos_x;i<w;i+=text_background->w)
		for(j=pos_y;j<h;j+=text_background->h)
		{
			r.x=i;
			r.y=j;
			r.w=text_background->w;
			r.h=text_background->h;
			SDL_BlitSurface(text_background,NULL,text_screen,&r);
		}
	if (menu_moving)
	{
#ifdef DREAMCAST
		text_draw_menu_msg();
#endif
		update_window_color();
	}
}

void text_flip(void)
{
	SDL_Delay(10);
	SDL_BlitSurface(text_screen,NULL,prSDLScreen,NULL);
	SDL_Flip(prSDLScreen);
}

void init_text(int splash)
{
	
	
	SDL_Surface *tmp;

	if (prSDLScreen==NULL)
	{
		SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_JOYSTICK);
		prSDLScreen=SDL_SetVideoMode(320,240,16,VIDEO_FLAGS);
    		SDL_ShowCursor(SDL_DISABLE);
 	   	SDL_JoystickEventState(SDL_ENABLE);
    		SDL_JoystickOpen(0);
	}
#ifdef DREAMCAST
        __sdl_dc_emulate_keyboard=1;
#endif
	if (!text_screen)
	{
		text_screen=SDL_CreateRGBSurface(prSDLScreen->flags,prSDLScreen->w,prSDLScreen->h,prSDLScreen->format->BitsPerPixel,prSDLScreen->format->Rmask,prSDLScreen->format->Gmask,prSDLScreen->format->Bmask,prSDLScreen->format->Amask);
		window_screen=SDL_CreateRGBSurface(prSDLScreen->flags,prSDLScreen->w,prSDLScreen->h,prSDLScreen->format->BitsPerPixel,prSDLScreen->format->Rmask,prSDLScreen->format->Gmask,prSDLScreen->format->Bmask,prSDLScreen->format->Amask);
		
		tmp=SDL_LoadBMP(MENU_FILE_TEXT);
		if (text_screen==NULL || tmp==NULL)
			exit(-1);
		text_image=SDL_DisplayFormat(tmp);
		SDL_FreeSurface(tmp);
		if (text_image==NULL)
			exit(-2);
		SDL_SetColorKey(text_image,(SDL_SRCCOLORKEY | SDL_RLEACCEL),SDL_MapRGB(text_image -> format, 0, 0, 0));
		tmp=SDL_LoadBMP(MENU_FILE_BACKGROUND);
		if (tmp==NULL)
			exit(-3);
		text_background=SDL_DisplayFormat(tmp);
		SDL_FreeSurface(tmp);
		if (text_background==NULL)
			exit(-3);
		tmp=SDL_LoadBMP(MENU_FILE_WINDOW);
		if (tmp==NULL)
			exit(-4);
		//text_window_background=SDL_DisplayFormat(tmp);
		//SDL_FreeSurface(tmp);
		//if (text_window_background==NULL)
			//exit(-5);
		SDL_Rect dest;
		dest.w=32;
		dest.h=24;
		for (int y=0;y<10;y++)
		{
			//text_window_background
			dest.y=24*y;
			for(int x=0;x<10;x++)
			{
				dest.x=32*x;
				SDL_BlitSurface(tmp,NULL,window_screen,&dest);
			}
		}
		SDL_FreeSurface(tmp);
		

	}
	if (splash)
	{
		SDL_Surface *sur;
		SDL_Rect r;
		int i,j;

		obten_colores();
		uae4all_init_sound();
		if (skipintro) 
			goto skipintro;
#if !defined(DEBUG_UAE4ALL) && !defined(PROFILER_UAE4ALL) && !defined(AUTO_RUN) && !defined(AUTO_FRAMERATE)
		tmp=SDL_LoadBMP(MENU_FILE_SPLASH);
		if (tmp==NULL)
			exit(-6);
		sur = SDL_DisplayFormat(tmp);
		SDL_FreeSurface(tmp);
		r.x=(text_screen->w - sur->w)/2;
		r.y=(text_screen->h - sur->h)/2;
		r.h=sur->w;
		r.w=sur->h;
		SDL_FillRect(text_screen,NULL,0xFFFFFFFF);
		for (i=128;i>-8;i-=8)
		{
#ifdef DREAMCAST
			vid_waitvbl();
#else
			SDL_Delay(50);
#endif
			SDL_FillRect(text_screen,NULL,0xFFFFFFFF);
			SDL_BlitSurface(sur,NULL,text_screen,&r);
			fade16(text_screen,i);
			text_flip();
		}
		SDL_Delay(3000);
		for(i=0;i<128;i+=16)
		{
#ifdef DREAMCAST
			vid_waitvbl();
#else
			SDL_Delay(50);
#endif
			SDL_FillRect(text_screen,NULL,0xFFFFFFFF);
			SDL_BlitSurface(sur,NULL,text_screen,&r);
			fade16(text_screen,i);
			text_flip();
		}
		for(i=128;i>-8;i-=8)
		{
#ifdef DREAMCAST
			vid_waitvbl();
#else
			SDL_Delay(50);
#endif
			text_draw_background();
			fade16(text_screen,i);
			text_flip();
		}
		SDL_FreeSurface(sur);
#else
#if !defined (DREAMCAST) && !defined (GP2X)
		chdir("example");
#else
#ifdef DREAMCAST
		fs_chdir("/cd");
#endif
#endif
#endif
skipintro:
		for(i=0;i<10;i++)
		{
			SDL_Event ev;
			if (!uae4all_init_rom(romfile))
				break;

			text_draw_background();
			text_draw_window(54,91,250,64,"--- ERROR ---");
			write_text(11,14,"KICK.ROM not found");
			write_text(8,16,"Press any button to retry");
			text_flip();
			SDL_Delay(333);
			while(SDL_PollEvent(&ev))
#ifndef DREAMCAST
				if (ev.type==SDL_QUIT)
					exit(1);
				else
#endif
				SDL_Delay(10);
			while(!SDL_PollEvent(&ev))
				SDL_Delay(10);
			while(SDL_PollEvent(&ev))
				if (ev.type==SDL_QUIT)
					exit(1);
			text_draw_background();
			text_flip();
			SDL_Delay(333);
		}
		if (i>=10)
			exit(1);
	}
	else
	{
		SDL_FillRect(text_screen,NULL,0xFFFFFFFF);
		text_flip();
		uae4all_resume_music();
	}
	menu_msg_time=SDL_GetTicks();
}


void quit_text(void)
{
/*
	SDL_FreeSurface(text_image);
	SDL_FreeSurface(text_background);
	SDL_FreeSurface(text_window_background);
	SDL_FreeSurface(text_screen);
*/
}

void write_text_pos(int x, int y, char * str)
{

  int i, c;
  SDL_Rect src, dest;
  
  for (i = 0; i < strlen(str); i++)
    {
      c = -1;
      
      if (str[i] >= '0' && str[i] <= '9')
	c = str[i] - '0';
      else if (str[i] >= 'A' && str[i] <= 'Z')
	c = str[i] - 'A' + 10;
      else if (str[i] >= 'a' && str[i] <= 'z')
	c = str[i] - 'a' + 36;
      else if (str[i] == '#')
	c = 62;
      else if (str[i] == '=')
	c = 63;
      else if (str[i] == '.')
	c = 64;
      else if (str[i] == '_')
	c = -2;
      else if (str[i] == '-')
	c = -3;
      else if (str[i] == '(')
	c = 65;
      else if (str[i] == ')')
	c = 66;
      
      if (c >= 0)
	{
	  src.x = c * 7;
	  src.y = 0;
	  src.w = 7;
	  src.h = 8;
	  
	  dest.x = x + (i * 7);
	  dest.y = y;
	  dest.w = 7;
	  dest.h = 8;
	  
	  SDL_BlitSurface(text_image, &src,
			  text_screen, &dest);
	}
      else if (c == -2 || c == -3)
	{
	  dest.x = x + (i * 8);
	  
	  if (c == -2)
	    dest.y = y  + 7;
	  else if (c == -3)
	    dest.y = y  + 3;
	  
	  dest.w = 7;
	  dest.h = 1;
	  
	  SDL_FillRect(text_screen, &dest, menu_barra0_color);
	}
    }
}
/*
void write_text(int x, int y, char * str)
{
	//printf("into write text with string %s\n",str);

	int i, c;
  SDL_Rect src, dest;
  dest.y=y*8;
  dest.w=5;
  dest.h=8;
	src.w=5;
	src.h=8;
	src.y=0;
 
  for (i = 0; i < strlen(str); i++)
   {
		src.x=(str[i]-33)*5;
		dest.x = (x + i) * 7;
		SDL_BlitSurface(text_image, &src,text_screen, &dest);
		if (i>40) break;
  }
}

*/
void write_text(int x, int y, char * str)
{
	//printf("into write text with string %s\n",str);

	int i, c;
  SDL_Rect src, dest;
  
  for (i = 0; i < strlen(str); i++)
    {
      c = -1;
	  
      
      if (str[i] >= '0' && str[i] <= '9')
	c = str[i] - '0';
      else if (str[i] >= 'A' && str[i] <= 'Z')
	c = str[i] - 'A' + 10;
      else if (str[i] >= 'a' && str[i] <= 'z')
	c = str[i] - 'a' + 36;
      else if (str[i] == '#')
	c = 62;
      else if (str[i] == '=')
	c = 63;
      else if (str[i] == '.')
	c = 64;
      else if (str[i] == '_')
	c = -2;
      else if (str[i] == '-')
	c = -3;
      else if (str[i] == '(')
	c = 65;
      else if (str[i] == ')')
	c = 66;
      
      if (c >= 0)
	{
	  src.x = c * 7;
	  src.y = 0;
	  src.w = 7;
	  src.h = 8;

	  dest.x = (x + i) * 7;
	  dest.y = y * 7; //10;
	  dest.w = 7;
	  dest.h = 8;
	  
	  SDL_BlitSurface(text_image, &src,
			  text_screen, &dest);
	}
      else if (c == -2 || c == -3)
	{
	  dest.x = (x + i) * 7;
	  
	  if (c == -2)
	    dest.y = y * 7 /*10*/ + 7;
	  else if (c == -3)
	    dest.y = y * 7 /*10*/ + 3;
	  dest.w = 7;
	  dest.h = 1;
	  
	  SDL_FillRect(text_screen, &dest, menu_barra0_color);
	}
	  if (i>42) break;
    }
}



/*void write_text(int x, int y, char * str)
{
	
	int i, c;
	SDL_Rect src, dest;
	  src.y = 0;
	  src.w = 7;
	  src.h = 8;

  	  dest.y = y * 7; //10;
	  dest.w = 7;
	  dest.h = 8;

  for (i = 0; i < strlen(str); i++)
  {
      c = -1;
      
    if (str[i] >= '0' && str[i] <= '9')c = str[i] - '0';
    else 
	if (str[i] >= 'A' && str[i] <= 'Z')c = str[i] - 'A' + 10;
    else 
	if (str[i] >= 'a' && str[i] <= 'z')c = str[i] - 'a' + 36;
    else if (str[i] == '#')c = 62;
    else if (str[i] == '=')c = 63;
    else if (str[i] == '.')c = 64;
    else if (str[i] == '_')c = 67;
    else if (str[i] == '-')c = 68;
	else if (str[i] == '(')c = 65;
	else if (str[i] == ')')c = 66;
    src.x = c * 7;
	dest.x = (x + i) * 7;
	SDL_BlitSurface(text_image, &src,text_screen, &dest);
   }
}


/* Write text, inverted: */

void write_text_inv(int x, int y, char * str)
{
  SDL_Rect dest;
  dest.x = (x * 7) -2 ;
  dest.y = (y * 7) /*10*/ - 2;
  dest.w = (strlen(str) * 7) + 4;
  dest.h = 12;

  SDL_FillRect(text_screen, &dest, menu_inv_color);

  write_text(x, y, str);
}
/*
void write_file_text(int x, int y, struct dirent **namelist, int &index)
{
	
	int i, c;
  SDL_Rect src, dest;
  char *str=&namelist[index];
  for (i = 0; i < strlen(str); i++)
    {
      c = -1;
      
      if (str[i] >= '0' && str[i] <= '9')
	c = str[i] - '0';
      else if (str[i] >= 'A' && str[i] <= 'Z')
	c = str[i] - 'A' + 10;
      else if (str[i] >= 'a' && str[i] <= 'z')
	c = str[i] - 'a' + 36;
      else if (str[i] == '#')
	c = 62;
      else if (str[i] == '=')
	c = 63;
      else if (str[i] == '.')
	c = 64;
      else if (str[i] == '_')
	c = -2;
      else if (str[i] == '-')
	c = -3;
      else if (str[i] == '(')
	c = 65;
      else if (str[i] == ')')
	c = 66;
      
      if (c >= 0)
	{
	  src.x = c * 7;
	  src.y = 0;
	  src.w = 7;
	  src.h = 8;
	  
	  dest.x = (x + i) * 7;
	  dest.y = y * 7; //10;
	  dest.w = 7;
	  dest.h = 8;
	  
	  SDL_BlitSurface(text_image, &src,
			  text_screen, &dest);
	}
      else if (c == -2 || c == -3)
	{
	  dest.x = (x + i) * 7;
	  
	  if (c == -2)
	    dest.y = y * 7 /*10*/ //+ 7;
/*  else if (c == -3)
	    dest.y = y * 7 /*10*/ //+ 3;
	  
/*	  dest.w = 7;
	  dest.h = 1;
	  
	  SDL_FillRect(text_screen, &dest, menu_barra0_color);
	}
    }
}
*/

/* Write text, inverted: */


/* Write text, horizontally centered... */

void write_centered_text(int y, char * str)
{
  write_text(40 - (strlen(str) / 2), y/2, str);
}


/* Write numbers on the option prSDLScreen: */

void write_num(int x, int y, int v)
{
  char str[24];
  
  sprintf(str, "%d", v);
  write_text(x, y, str);
}

void write_num_inv(int x, int y, int v)
{
  SDL_Rect dest;
  int i,l=1;

  for(i=10;i<1000000;i*=10)
	if (v/i)
		l++;
  	else
		break;
  	
  dest.x = (x * 7) -2 ;
  dest.y = (y * 8) /*10*/ - 2;
  dest.w = (l * 7) + 4;
  dest.h = 12;

  SDL_FillRect(text_screen, &dest, menu_inv_color);

  write_num(x, y, v);
}
/*
void fixDisplay()
{
	SDL_Rect visible_area;
	visible_area.x = 0;
	visible_area.y = 0;
	visible_area.w = 320;
	visible_area.h = 240;
	SDL_GP2X_Display(&visible_area);
}
void menuin_Effect()
{
	
	SDL_Rect visible_area;
	visible_area.x = 0;
	visible_area.y = 0;
	visible_area.w = 1;
	visible_area.h = 1;
	SDL_GP2X_Display(&visible_area);
	text_flip();
	int i;
	for(i=1;i<=320;i+=16)
	{
		visible_area.x = 0;
		visible_area.y = 0;
		visible_area.w = i;
		visible_area.h = 240;
		SDL_GP2X_Display(&visible_area);
		usleep(50);
	}
	visible_area.x = 0;
	visible_area.y = 0;
	visible_area.w = 320;
	visible_area.h = 240;
	SDL_GP2X_Display(&visible_area);	
}
void clearScreen()
{
	SDL_Rect r;
	r.x=0;
	r.y=0;
	r.w=320;
	r.h=240;

	SDL_FillRect(prSDLScreen,&r,menu_win0_color);
}


void menuout_Effect()
{
		
		SDL_Rect visible_area;
	/*	visible_area.x = 0;
		visible_area.y = 0;
		visible_area.w = 0;
		visible_area.h = 240;
		SDL_GP2X_Display(&visible_area);

	int i;
		for(i=320;i>=0;i-=16)
		{
			visible_area.x = 0;
			visible_area.y = 0;
			visible_area.w = i;
			visible_area.h = 240;
			SDL_GP2X_Display(&visible_area);
			usleep(50);
		}
		/*visible_area.x = 0;
		visible_area.y = 0;
		visible_area.w = 320;
		visible_area.h = 240;
		SDL_GP2X_Display(&visible_area);



}
*/


void text_draw_window(int x, int y, int w, int h, char *title)
{
	int i,j;
	int x_screen = x * 7;
	int y_screen = y * 8;

	int x_corn = x_screen-2;
	int y_corn = y_screen-12;
	int w_corn = (w*7)+4;
	int h_corn = (h*8)+4+12;

	int x_shadow = x_corn+w_corn;
	int y_shadow = y_corn+6;
	int w_shadow = 10;
	int h_shadow = h_corn+4;

	
	int x_shadow_d = x_corn+5;
	int y_shadow_d = y_corn+h_corn;
	int w_shadow_d = w_corn-5;
	int h_shadow_d = 10;

	
	
	SDL_Rect dest;





	/*dest.x = rx + 6;
	dest.y = ry - 4;
	dest.w = rw + 6;
	dest.h = rh + 18;
//	SDL_FillRect(text_screen, &dest, menu_win0_color);
*/

	dest.x = x_shadow;
	dest.y = y_shadow;
	dest.w = w_shadow;
	dest.h = h_shadow;

	SDL_FillRect(text_screen, &dest, menu_win0_color);
//	boxRGBA(text_screen,dest.x,dest.y,dest.w,dest.h,0x20,0x20,0x30,160);

	dest.x = x_shadow_d;
	dest.y = y_shadow_d;
	dest.w = w_shadow_d;
	dest.h = h_shadow_d;

	SDL_FillRect(text_screen, &dest, menu_win0_color);
//	boxRGBA(text_screen,dest.x,dest.y,dest.w,dest.h,0x20,0x20,0x30,160);

	dest.x = x_corn;
	dest.y = y_corn;
	dest.w = w_corn;

	dest.h = h_corn; //16;
	SDL_FillRect(text_screen, &dest, menu_win1_color);
	//boxRGBA(text_screen,dest.x,dest.y,dest.w,dest.h,0x70,0x70,0x80,160);

	dest.x=x_screen;
	dest.y=y_screen;
	dest.w=w*7;
	dest.h=h*8;
	SDL_BlitSurface(window_screen,&dest,text_screen,&dest);
	//boxRGBA(text_screen,x_screen,y_screen,w*7,w*8,255,255,255,160);


	write_text(x + ((w-strlen(title)) / 2), y-1, title);

}
