unit ScriptExecUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, process, SynMemo, txprocess, txkinscroller, txproximity, SynEdit,
  qt4, qtwidgets, txqtfunc, txdbus;

type
  { TScriptExecF }
  TScriptExecF = class(TForm)
    Edit1: TEdit;
    PageDownButton: TButton;
    PageDownFullButton: TButton;
    PageUpButton: TButton;
    PageUpFullButton: TButton;
    SynEdit1: TSynEdit;
    procedure Edit1KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure PageDownButtonClick(Sender: TObject);
    procedure PageDownFullButtonClick(Sender: TObject);
    procedure PageUpButtonClick(Sender: TObject);
    procedure PageUpFullButtonClick(Sender: TObject);
    procedure SynEdit1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SynEdit1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SynEdit1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { private declarations }
  public
    { public declarations }
    ScriptName : string;
    proc : TTxProcess;
    kinscroll : TTxKinScroller;
    iconPageUpH, iconPageUpFullH, iconPageDownH, iconPageDownFullH : QIconH;
    procedure ExecuteIt;
    procedure SendInput(Process:TProcess;InputEdit:TEdit);
  end; 

var
  ScriptExecF: TScriptExecF;

implementation

uses MainUnit;

{$R *.lfm}

procedure TScriptExecF.FormClose(Sender: TObject; var CloseAction: TCloseAction
  );
begin
  if proc.FProcess.Running then
    proc.FProcess.Terminate(0);
  proc.Free;
  kinscroll.Free;
  CloseAction := caFree;
end;

procedure TScriptExecF.FormCreate(Sender: TObject);
var
  btn : TQtPushButton;
  iconFile : WideString;
begin
  QWidget_setAttribute(TQtWidget(Self.Handle).Widget,QtWA_Maemo5StackedWindow , true);
  if MainForm.Settings.AppOrientation = aoAuto then
    RotateApp(Self.Handle,aoAuto);
  if MainForm.Settings.AppOrientation = aoVertical then
    RotateApp(Self.Handle,aoVertical);
  if MainForm.Settings.AppOrientation = aoHorizontal then
    RotateApp(Self.Handle,aoHorizontal);

  kinscroll := TTxKinScroller.Create(Self);
  kinscroll.TargetControl := SynEdit1;

  // Page up button
  btn := TQtPushButton(PageUpButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_up.png';
  iconPageUpH := QIcon_create(@iconFile);
  btn.setIcon(iconPageUpH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';

  // Page up full button
  btn := TQtPushButton(PageUpFullButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_up_full.png';
  iconPageUpFullH := QIcon_create(@iconFile);
  btn.setIcon(iconPageUpFullH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';

  // Page down button
  btn := TQtPushButton(PageDownButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_down.png';
  iconPageDownH := QIcon_create(@iconFile);
  btn.setIcon(iconPageDownH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';

  // Page down full button
  btn := TQtPushButton(PageDownFullButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_down_full.png';
  iconPageDownFullH := QIcon_create(@iconFile);
  btn.setIcon(iconPageDownFullH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';

  SynEdit1.Color:= MainForm.Settings.ColorScheme.Background;
  SynEdit1.Font.Color:= MainForm.Settings.ColorScheme.Text;
  SynEdit1.Gutter.Color := MainForm.Settings.ColorScheme.Gutter;
  SynEdit1.Gutter.Parts.Part[1].MarkupInfo.Background := MainForm.Settings.ColorScheme.Gutter;
  SynEdit1.Gutter.Parts.Part[1].MarkupInfo.Foreground := MainForm.Settings.ColorScheme.GutterText;
  SynEdit1.Gutter.Parts.Part[4].MarkupInfo.Foreground := MainForm.Settings.ColorScheme.CodeFolder;
  QWidget_setInputMethodHints(TQtWidget(SynEdit1.Handle).Widget,QtImhNoAutoUppercase);
  QWidget_setInputMethodHints(TQtWidget(Edit1.Handle).Widget,QtImhNoAutoUppercase);
end;

procedure TScriptExecF.FormShow(Sender: TObject);
begin
  SynEdit1.SetFocus;
end;

procedure TScriptExecF.PageDownButtonClick(Sender: TObject);
begin
  with SynEdit1 do
    begin
      TopLine := TopLine + (LinesInWindow);
    end;
end;

procedure TScriptExecF.PageDownFullButtonClick(Sender: TObject);
begin
  with SynEdit1 do
    begin
      TopLine := Lines.Count;
    end;
end;

procedure TScriptExecF.PageUpButtonClick(Sender: TObject);
begin
  with SynEdit1 do
    begin
      TopLine := TopLine - (LinesInWindow);
    end;
end;

procedure TScriptExecF.PageUpFullButtonClick(Sender: TObject);
begin
  with SynEdit1 do
    begin
      TopLine := 0;
    end;
end;

procedure TScriptExecF.SynEdit1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(kinscroll) and isProxClosed then
    begin
      kinScroll.MouseDown(X,Y);
      with Sender as TSynEdit do
        Options:= Options+[eoNoSelection, eoNoCaret];
    end;
end;

procedure TScriptExecF.SynEdit1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if Assigned(kinscroll) and isProxClosed then
    begin
      kinScroll.MouseMove(X,Y);
    end;
end;

procedure TScriptExecF.SynEdit1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(kinscroll) then
    begin
      KinScroll.MouseUp(X,Y);
      with Sender as TSynEdit do
        Options:= Options-[eoNoSelection, eoNoCaret];
    end;
end;

procedure TScriptExecF.Edit1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = 13 then
    begin
      if proc.FProcess.Running then
        begin
          SendInput(proc.FProcess,Edit1);
          Edit1.Clear;
        end
      else
        ShowDBusMiniMessage('Can''t send, process not running!');
    end;
end;

procedure TScriptExecF.ExecuteIt;
begin
  proc := TTxProcess.Create;
  proc.CmdLine := '/bin/sh '+ScriptName;
  proc.FOutMemo := SynEdit1;
  proc.Execute;
end;

procedure TScriptExecF.SendInput(Process:TProcess;InputEdit:TEdit);
var
  InputStrings: string;
begin
  if proc.FProcess.Running then
  begin
    InputStrings := InputEdit.Text;
    proc.FProcess.Input.Write(InputStrings[1], length(InputStrings));
  end;
end;

end.

