unit FTPProgressDlg;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ComCtrls,
  StdCtrls, ExtCtrls, IdFTP, FTPServerList, IdComponent, txinputdlg, conic, txdbus;

type
  TFTPDlgAction = (daGet, daPut);

  { TFTPProgressDlgF }
  TFTPProgressDlgF = class(TForm)
    Button1: TButton;
    ProgressBar1: TProgressBar;
    GetTimer: TTimer;
    PutTimer: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
procedure FormShow(Sender: TObject);
    procedure GetTimerTimer(Sender: TObject);
    procedure PutTimerTimer(Sender: TObject);
  private
    { private declarations }
  public
    FTPWorking : boolean;
    FTPAborted : boolean;
    currentStatus : TIdStatus;
    RemoteFileName : string;
    LocalFileName : string;
    FTPAction : TFTPDlgAction;
    FTP : TIdFTP;
    FTPServer : TxFtpServer;
    procedure ExecuteFTPAction;
    procedure ftpWorkBeginEvent(ASender: TObject; AWorkMode: TWorkMode; AWorkCountMax: Int64);
    procedure ftpWorkEndEvent(ASender: TObject; AWorkMode: TWorkMode);
    procedure ftpWorkEvent(ASender: TObject; AWorkMode: TWorkMode; AWorkCount: Int64);
    procedure ftpOnConnected(Sender: TObject);
    procedure ftpStatusEvent(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
    { public declarations }
  end; 

var
  FTPProgressDlgF: TFTPProgressDlgF;

implementation

{$R *.lfm}

procedure TFTPProgressDlgF.ftpWorkBeginEvent(ASender: TObject; AWorkMode: TWorkMode; AWorkCountMax: Int64);
begin
  ProgressBar1.Max := AWorkCountMax;
  ProgressBar1.Position := 0;
end;

procedure TFTPProgressDlgF.ftpWorkEndEvent(ASender: TObject; AWorkMode: TWorkMode);
begin
  if not FTPAborted then
    ModalResult := mrOk
  else
    ModalResult := mrAbort;
end;

procedure TFTPProgressDlgF.ftpWorkEvent(ASender: TObject; AWorkMode: TWorkMode; AWorkCount: Int64);
begin
  ProgressBar1.Position := AWorkCount;
  Application.ProcessMessages;
end;

procedure TFTPProgressDlgF.ftpOnConnected(Sender: TObject);
begin

end;

procedure TFTPProgressDlgF.ftpStatusEvent(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
begin
  currentStatus := AStatus;
  if AStatus = hsConnected then
    begin
      case FTPAction of
        daPut :
          begin
            Caption := 'FTP Progress - Sending...';
            Application.ProcessMessages;
            PutTimer.Enabled := True;
          end;
        daGet :
          begin
            Caption := 'FTP Progress - Downloading...';
            Application.ProcessMessages;
            GetTimer.Enabled := True;
          end;
      end;
    end;
end;

procedure TFTPProgressDlgF.FormShow(Sender: TObject);
begin
  Application.ProcessMessages;
  FTPAborted := False;
  ExecuteFTPAction;
end;

procedure TFTPProgressDlgF.Button1Click(Sender: TObject);
begin
  FTPAborted := True;
  ftp.Abort;
  ModalResult := mrAbort;
end;

procedure TFTPProgressDlgF.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
begin
  ftp.Free;
end;

procedure TFTPProgressDlgF.GetTimerTimer(Sender: TObject);
begin
  Application.ProcessMessages;
  if ftp.Connected and (currentStatus = ftpReady) and not FTPWorking then
    begin
      GetTimer.Enabled := False;
      FTPWorking := True;
      try
        FTP.Get(RemoteFileName, LocalFileName,True);
      except
        on E:Exception do
          begin
            ShowMessage(E.Message);
            Exit;
          end;
      end;
    end;
end;

procedure TFTPProgressDlgF.PutTimerTimer(Sender: TObject);
begin
  Application.ProcessMessages;
  if ftp.Connected and (currentStatus = ftpReady) and not FTPWorking then
    begin
      PutTimer.Enabled := False;
      FTPWorking := True;
      try
        FTP.Put(LocalFileName, RemoteFileName);
      except
        on E:Exception do
          begin
            ShowMessage(E.Message);
            Exit;
          end;
      end;
    end;
end;

procedure TFTPProgressDlgF.ExecuteFTPAction;
begin
  if not CreateWorkingIC then
    begin
      ShowDBusMiniMessage('No internet connection available, connection failed!');
      ModalResult := mrAbort;
      Close;
      Exit;
    end;

  ftp := TIdFTP.Create(Self);
  ftp.OnWorkBegin := @ftpWorkBeginEvent;
  ftp.OnWorkEnd := @ftpWorkEndEvent;
  ftp.OnWork := @ftpWorkEvent;
  ftp.OnConnected := @ftpOnConnected;
  ftp.OnStatus := @ftpStatusEvent;
  ftp.Host := FTPServer.Address;
  ftp.Username := FTPServer.Username;
  if FTPServer.Password = '' then
    begin
      TxInputDlgF.Caption := 'Enter the password';
      if TxInputDlgF.ShowModal = mrOk then
        begin
          FTPServer.Password := TxInputDlgF.Edit1.Text;
          TxInputDlgF.Caption := 'Input';
        end
    end
  else
    ftp.Password := FTPServer.Password;
  ftp.Port:= StrToInt(FTPServer.Port);
  ftp.Passive := FTPServer.Passive;
  try
    ftp.Connect;
  except
    on E:Exception do
      begin
        ShowMessage(E.Message);
        Exit;
      end;
  end;
end;

end.

