unit SaveDlg;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ShellCtrls,
  ExtCtrls, StdCtrls, txkinscroller;

type

  { TSaveDlgF }

  TSaveDlgF = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    Panel1: TPanel;
    ShellListView1: TShellListView;
    ShellTreeView1: TShellTreeView;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Edit1KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ShellTreeView1Click(Sender: TObject);
    procedure ShellTreeView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ShellTreeView1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ShellTreeView1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { private declarations }
  public
    { public declarations }
    FName : string;
    kinscroll : TTxKinScroller;
  end;


var
  SaveDlgF: TSaveDlgF;


implementation

{$R *.lfm}

{ TSaveDlgF }

procedure TSaveDlgF.Edit1KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if key = 13 then
    Button1.OnClick(Self);
end;

procedure TSaveDlgF.FormCreate(Sender: TObject);
begin
  kinscroll := TTxKinScroller.Create(SaveDlgF);
  kinscroll.TargetControl := ShellTreeView1;
  kinscroll.Enabled := True;
end;

procedure TSaveDlgF.FormDestroy(Sender: TObject);
begin
  kinscroll.Free;
end;

procedure TSaveDlgF.FormShow(Sender: TObject);
var
  i : integer;
begin
  SaveDlgF.ModalResult := mrNone;
  if ShellListView1.ColumnCount > 1 then
    for i := 1 to ShellListView1.ColumnCount-1 do
      begin
        ShellListView1.Column[i].Visible:= False;
      end;
  ShellListView1.Column[0].MinWidth:= ShellListView1.Width;
end;

procedure TSaveDlgF.ShellTreeView1Click(Sender: TObject);
begin
  if not kinscroll.InertiaActive then
    begin
      if ShellTreeView1.Selected.Expanded then
        ShellTreeView1.Selected.Collapse(False)
      else
        ShellTreeView1.Selected.Expand(False);
      Edit1.Text := ShellTreeView1.GetPathFromNode(ShellTreeView1.Selected)+'/';
    end;
end;

procedure TSaveDlgF.ShellTreeView1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(kinscroll) then
    kinscroll.MouseDown(X,Y);
end;

procedure TSaveDlgF.ShellTreeView1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(kinscroll) then
    kinscroll.MouseMove(X,Y);
end;

procedure TSaveDlgF.ShellTreeView1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(kinscroll) then
    kinscroll.MouseUp(X,Y);
end;

procedure TSaveDlgF.Button1Click(Sender: TObject);
begin
  FName := '';
  if ExtractFileName(Edit1.Text) <> '' then
    begin
      if FileExists(Edit1.Text) then
        begin
          if MessageDlg('File allready exists', 'Do you want to overwrite?', mtConfirmation,[mbYes, mbNo],0 ) <> mrYes then
            Exit;
        end;
      FName := Edit1.Text;
    end
  else
    begin
      ShowMessage('Enter the file name first!');
      Exit;
    end;
  SaveDlgF.ModalResult := mrOk;
end;

procedure TSaveDlgF.Button2Click(Sender: TObject);
begin
  FName := '';
  SaveDlgF.ModalResult := mrCancel;
end;

end.

