unit pastebin;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls, IdHTTP,
  conic;

type

  { TPasteBinF }

  TPasteBinF = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
  private
    { private declarations }
  public
    { public declarations }
    procedure RepChar(var sl :TStringList; i : integer; s1, s2 : string);
    procedure PreparePaste(var se : TStringList);
  end; 

var
  PasteBinF: TPasteBinF;

implementation

uses MainUnit, txdbus;

{$R *.lfm}

{ TPasteBinF }

procedure TPasteBinF.RepChar(var sl :TStringList; i : integer; s1, s2 : string);
var
  index : integer;
  s : string;
begin
  while Pos(s1,sl[i]) > 0 do
    begin
      index := Pos(s1,sl[i]);
      s := sl[i];
      Delete(s,index,1);
      Insert(s2,s,index);
      sl[i] := s;
    end;
end;

procedure TPasteBinF.PreparePaste(var se : TStringList);
var
  i, index : integer;
  s ,t : string;
begin
  for i := 0 to se.Count-1 do
    begin
      RepChar(se,i,'!','%21');
      RepChar(se,i,'*','%2A');
      RepChar(se,i,'''','%27');
      RepChar(se,i,'(','%28');
      RepChar(se,i,')','%29');
      RepChar(se,i,';','%3B');
      RepChar(se,i,':','%3A');
      RepChar(se,i,'@','%40');
      RepChar(se,i,'&','%26');
      RepChar(se,i,'=','%3D');
      RepChar(se,i,'+','%2B');
      RepChar(se,i,'$','%24');
      RepChar(se,i,',','%2C');
      RepChar(se,i,'/','%2F');
      RepChar(se,i,'?','%3F');
      RepChar(se,i,'#','%23');
      RepChar(se,i,'[','%5B');
      RepChar(se,i,']','%5D');
      t := se[i];
      while Pos('\',t) > 0 do
        begin
          index := Pos('\',t);
          s := se[i];
          Delete(s,index,1);
          Insert('\\',s,index);
          Delete(t,Pos('\',t),1);
          Insert('z',t,index);
          se[i] := s;
        end;
    end;
end;

procedure TPasteBinF.Button1Click(Sender: TObject);
var
  ht : TIdHTTP;
  r : string;
  str : TStringList;
  se : TStringList;
  s1 : TStringStream;
  failed : boolean;
begin
  Button1.Enabled := False;
  if not CreateWorkingIC then
    begin
      ShowDBusMiniMessage('No internet connection available, paste failed!');
      Exit;
    end;
  sleep(1000);
  se := TStringList.Create;
  ht := TIdHTTP.Create(MainForm);
  str := TStringList.Create;
  ht.Request.ContentType := 'application/x-www-form-urlencoded';
  str.Add('name='+Edit1.Text);
  str.Add('&lang='+Edit2.Text);
  if MainForm.Docs[MainForm.GetDocIDByTag(MainForm.pg.ActivePage.Tag)].Edit.SelText <> '' then
    begin
      se.SetText(PChar(MainForm.Docs[MainForm.GetDocIDByTag(MainForm.pg.ActivePage.Tag)].Edit.SelText));
      PreparePaste(se);
      str.Add('&data='+se.GetText);
    end
  else
    begin
      se.SetText(PChar(MainForm.Docs[MainForm.GetDocIDByTag(MainForm.pg.ActivePage.Tag)].Edit.Text));
      PreparePaste(se);
      str.Add('&data='+se.GetText);
    end;
  s1 := TStringStream.Create(str.GetText);
  failed := False;
  try
    r := ht.Post('http://txpad.devbin.org/paste.php',s1);
  except
    on E: Exception do
      begin
        ShowDBusMessage('Paste failed! Check your internet connection.');
        failed := True;
      end;
  end;
  if not failed then
    begin
      Edit3.Text := 'http://txpad.devbin.org/index.php?site=show&id='+r;
      Edit3.SelectAll;
      ShowDBusMiniMessage('Paste sent!');
    end;
  se.Free;
  s1.Free;
  str.Free;
end;

procedure TPasteBinF.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TPasteBinF.Button3Click(Sender: TObject);
begin
  Edit3.SelectAll;
  Edit3.CopyToClipboard;
  ShowDBusMiniMessage('Copied');
end;

procedure TPasteBinF.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  Edit1.Clear;
  Edit2.Clear;
  Edit3.Clear;
  Button1.Enabled := True;
end;

end.

