/*
    Copyright 2011 - Tommi Laukkanen (www.substanceofcode.com)

    This file is part of TwimGo.

    TwimGo is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    TwimGo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TwimGo. If not, see <http://www.gnu.org/licenses/>.
*/

import Qt 4.7

Item {
    id: welcomeItem
    anchors.fill: parent
    signal login()
    signal exit()
    property string username: ""
    property string password: ""
    state: "hidden"

    MouseArea {
        anchors.fill: parent
        onClicked: {
            console.log("..");
        }
    }

    CustomTheme {
        id: theme
    }

    Rectangle {
        id: welcomePage
        anchors.fill: parent

        //color: theme.dialogBG

        gradient: Gradient {
            GradientStop { position: 0.0; color: "#E73525" }
            GradientStop { position: 0.25; color: "#DB3223" }
            GradientStop { position: 0.75; color: "#D23022" }
            GradientStop { position: 1.0; color: "#AD2B1F" }
        }

        Image {
            id: logo
            source: "../pics/icon.png"
            anchors.centerIn: parent

            SequentialAnimation on scale {
                NumberAnimation {
                    from: 0.8
                    to: 1.0
                    duration: 700
                    easing.type: "InOutCubic"
                }
            }
            SequentialAnimation on opacity {
                NumberAnimation {
                    from: 0.0
                    to: 1.0
                    duration: 900
                }
                /*ScriptAction {
                    script: {
                        credentials.state = "shown";
                    }
                }*/
            }
        }

        BackButton {
            id: quitButton
            icon: "../pics/delete.png"
            x: parent.width - width
            y: 0
            onClicked: {
                Qt.quit();
            }
        }

        Text {
            id: copy
            text: "v2.8.6 © 2011 Tommi Laukkanen<br/>www.substanceofcode.com"
            y: parent.height - height - 8
            width: parent.width
            horizontalAlignment: Text.Center
            color: "#E8DDCB"
        }

        Rectangle {
            id: credentials
            width: parent.width
            y: 0
            height: loginButtonContainer.y + loginButtonContainer.height + 20
            state: "hidden"

            color: theme.dialogBG
            /*
            gradient: Gradient {
                GradientStop { position: 0.0; color: "#ccc" }
                GradientStop { position: 0.9; color: "#ccc" }
                GradientStop { position: 1.0; color: "#999" }
            }*/

            Text {
                id: usernameLabel
                text: "Username"
                y: 20
                x: 10
                color: "#eee"
                font.pixelSize: 22
            }

            Rectangle {
                id: usernameContainer
                height: usernameInput.height + 10
                width: parent.width - x - 10
                x: usernameLabel.x + usernameLabel.width + 10
                y: usernameLabel.y
                gradient: Gradient {
                    GradientStop { position: 0.0; color: "#ccc" }
                    GradientStop { position: 0.2; color: "#fafafa" }
                    GradientStop { position: 1.0; color: "#fff" }
                }
                radius: 5
                border.width: 1
                border.color: "#aaa"
                smooth: true

                TextInput {
                    id: usernameInput
                    text: welcomeItem.username
                    x: 5
                    width: parent.width - 10
                    y: 5
                    color: "#111"
                    font.pixelSize: 22
                    focus: true
                }
            }

            Image {
                source: "../pics/top-shadow.png"
                y: parent.height
                height: 16
                anchors.right: parent.right
                anchors.rightMargin: 0
                anchors.left: parent.left
                anchors.leftMargin: 0
            }

            Text {
                id: passwordLabel
                text: "Password"
                color: "#eee"
                y: usernameContainer.y + usernameContainer.height + 20
                x: 10
                font.pixelSize: 22
            }

            Rectangle {
                id: passwordContainer
                height: passwordInput.height + 10
                width: parent.width - x - 10
                x: usernameLabel.x + usernameLabel.width + 10
                y: passwordLabel.y
                gradient: Gradient {
                    GradientStop { position: 0.0; color: "#ccc" }
                    GradientStop { position: 0.2; color: "#fafafa" }
                    GradientStop { position: 1.0; color: "#fff" }
                }
                radius: 5
                border.width: 1
                border.color: "#aaa"
                smooth: true

                TextInput {
                    id: passwordInput
                    text: welcomeItem.password
                    x: 5
                    y: 5
                    width: parent.width - 10
                    color: "#111"
                    echoMode: TextInput.Password
                    font.pixelSize: 22
                }
            }

            Rectangle {
                id: loginButtonContainer
                radius: 5
                color: theme.dialogButtonAreaBG // "#999"
                x: 10
                width: parent.width - 20
                height: 70
                y: passwordContainer.y  + passwordContainer.height + 20

                Button {
                    id: loginButton
                    label: "Login"
                    width: parent.width/2 - 15
                    x: 10
                    y: 10 //
                    onClicked: {
                        username = usernameInput.text;
                        password = passwordInput.text;
                        welcomeItem.login();
                        credentials.state = "hidden";
                    }
                }

                Button {
                    id: cancelButton
                    label: "Exit"
                    width: parent.width/2 - 15
                    x: parent.width/2 + 5
                    y: 10
                    onClicked: {
                        welcomeItem.exit();
                    }
                }
            }

            states: [
                State {
                    name: "hidden"
                    PropertyChanges {
                        target: credentials
                        y: 0 - credentials.height - 16
                    }
                },
                State {
                    name: "shown"
                    PropertyChanges {
                        target: credentials
                        y: 0
                    }
                }
            ]

            transitions: Transition {
                SequentialAnimation {
                    PropertyAnimation {
                        target: credentials
                        properties: "y"
                        duration: 800
                        easing.type: "InOutCubic"
                    }
                }
            }
        }

    }

    states: [
        State {
            name: "hidden"
            changes: [
/*                PropertyChanges {
                    target: welcomePage
                    x: 0 - welcomePage.width
                },
  */              PropertyChanges {
                    target: credentials
                    state: "hidden"
                }
            ]
        },
        State {
            name: "shown"
            changes: [
    /*            PropertyChanges {
                    target: welcomePage
                    x: 0
                },
                PropertyChanges {
                    target: welcomeItem
                    y: 0
                },*/
                PropertyChanges {
                    target: credentials
                    state: "shown"
                },
                PropertyChanges {
                    target: credentials
                    y: 0
                },
                PropertyChanges {
                    target: credentials
                    visible: true
                },
                PropertyChanges {
                    target: welcomeItem
                    visible: true
                }
            ]
        }
    ]

    function showLogin() {
        credentials.visible = true;
        credentials.y = 0;
        credentials.state = "shown";
    }

    transitions: Transition {
        from: "hidden"
        SequentialAnimation {
            PropertyAnimation {
                target: welcomePage
                properties: "x"
                duration: 600
                easing.type: "InOutCubic"
            }
        }
    }

}
