/*
    Copyright 2011 - Tommi Laukkanen (www.substanceofcode.com)

    This file is part of TwimGo.

    TwimGo is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    TwimGo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TwimGo. If not, see <http://www.gnu.org/licenses/>.
*/

import Qt 4.7

Item {
    id: searchDialogItem
    signal clicked()
    property string searchText: ""
    width: parent.width; height: 160
    state: "hidden"

    CustomTheme {
        id: theme
    }

    Rectangle {
        id: searchDialog
        width: parent.width
        y: 0
        height: searchButtonContainer.y + searchButtonContainer.height + 30

        color: theme.dialogBG
        /*
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#ccc" }
            GradientStop { position: 0.9; color: "#ccc" }
            GradientStop { position: 1.0; color: "#999" }
        }*/

        MouseArea {
            anchors.fill: parent
            onClicked: {
                // Do nothing - Don't let the clicks leak underneath component
            }
        }

        Text {
            id: searchLabel
            text: "Search tweets"
            font.pixelSize: 22
            y: 20
            x: 10
            color: "#eee"
        }

        Rectangle {
            id: searchTextContainer
            height: searchText.height + 10
            width: parent.width-20
            x: 10
            y: searchLabel.y + searchLabel.height
            gradient: Gradient {
                GradientStop { position: 0.0; color: "#ccc" }
                GradientStop { position: 0.1; color: "#fafafa" }
                GradientStop { position: 1.0; color: "#fff" }
            }
            radius: 5
            border.width: 1
            border.color: "#aaa"
            smooth: true

            TextInput {
                id: searchText
                text: ""
                width: parent.width - 10
                x: 5
                y: 5
                //anchors.fill: parent
                color: "#111"
                font.pixelSize: 22
                focus: true
            }
        }

        Rectangle {
            id: searchButtonContainer
            radius: 5
            color: theme.dialogButtonAreaBG // "#999"
            //y: tweetTextContainer.y + tweetTextContainer.height + 20
            x: 10
            width: parent.width - 20
            height: 70
            y: searchTextContainer.y + searchTextContainer.height + 20

            Button {
                id: searchButton
                label: "Search"
                width: parent.width/2 - 15
                x: 10
                y: 10 //
                onClicked: {
                    searchDialogItem.searchText = searchText.text;
                    searchDialogItem.clicked();
                    searchDialogItem.state = "hidden"
                }
            }

            Button {
                id: cancelButton
                label: "Cancel"
                width: parent.width/2 - 15
                x: parent.width/2 + 5
                y: 10 //
                onClicked: {
                    searchDialogItem.state = "hidden"
                }
            }
        }

        Image {
            source: "../pics/top-shadow.png"
            y: parent.height
            height: 16
            anchors.right: parent.right
            anchors.rightMargin: 0
            anchors.left: parent.left
            anchors.leftMargin: 0
        }
    }

    states:
        State {
        name: "hidden"
        PropertyChanges {
            target: searchDialog
            y: 0 - searchDialog.height - 16
        }
    }
    State {
        name: "shown"
        PropertyChanges {
            target: searchDialog
            y: 0
        }
    }

    transitions: Transition {
        SequentialAnimation {
            PropertyAnimation {
                target: searchDialog
                properties: "y"
                duration: 600
                easing.type: "OutQuad"
            }
        }
    }

}
