/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "applicationmanager.h"

/*!
 * \brief ApplicationManager constructor.
 */
ApplicationManager::ApplicationManager(QGraphicsScene *scene)
    : _autologin(true)
{
    _scene = scene;

    changeOrientation();
    connect(QApplication::desktop(), SIGNAL(resized(int)), SLOT(changeOrientation()));
}

/*!
 * \brief Creates a new loginScreen controller.
 */
void ApplicationManager::loginScreen(void)
{
    _loginCtrl = new LoginCtrl(_autologin, _scene);
    connect(_loginCtrl, SIGNAL(done()), SIGNAL(loginFinished()));
    connect(_loginCtrl, SIGNAL(lockRotation(bool)), SLOT(_lockRotation(bool)));
}

/*!
 * \brief Creates a new timelineScreen controller.
 */
void ApplicationManager::timelineScreen(void)
{
    _autologin = false;

    _timelineCtrl = new TimelineCtrl(_scene);
    connect(_timelineCtrl,SIGNAL(done()), SIGNAL(timelineFinished()));
    connect(_timelineCtrl, SIGNAL(lockRotation(bool)), SLOT(_lockRotation(bool)));
}

void ApplicationManager::_lockRotation(bool lock)
{
    #ifdef Q_WS_MAEMO_5
        QList<QGraphicsView*> views = _scene->views();
        views[0]->setAttribute(Qt::WA_Maemo5AutoOrientation, !lock);
    #endif
}

void ApplicationManager::changeOrientation(void)
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    QPixmap bg(QPixmap(":images/resources/Background.png"));
    QPixmap bgPor(QPixmap(":images/resources/Background_p.png"));

    if(screenGeometry.width() > screenGeometry.height()) {
        _scene->setBackgroundBrush(bg);
        _scene->setSceneRect(0, 0, 800, 480);
    } else if (screenGeometry.width() < screenGeometry.height()) {
        _scene->setBackgroundBrush(bgPor);
        _scene->setSceneRect(0, 0, 480, 800);
    }
}
