#include "account.h"

Account::Account() :
    user(UserInfo()),
    avatar(QImage()),
    token(QString()),
    tokenSecret(QString()),
    lastTweets(EntryList()),
    showAvatar(true),
    showUsername(true),
    showTimestamp(true),
    showReplyTo(true),
    highlightUrls(true),
    highlightMentions(true),
    highlightTags(true)
{}

void Account::initialize(void)
{
    user.initialize();
    avatar = QImage();
    token = QString();
    tokenSecret = QString();
    lastTweets.clear();
    showAvatar = true;
    showUsername = true;
    showTimestamp = true;
    showReplyTo = true;
    highlightUrls = true;
    highlightMentions = true;
    highlightTags = true;
}

void Account::setTokens(QString t, QString tSecret)
{
    token = t;
    tokenSecret = tSecret;
}

QString Account::getTokenString(void)
{
    return token + "&" + tokenSecret;
}

void Account::setUsername(QString username)
{
    user.screenName = username;
}

QString Account::getUsername(void)
{
    return user.screenName;
}

bool Account::operator == (const Account &other)
{
    return ( user == other.user
            && avatar == other.avatar
            && token == other.token
            && tokenSecret == other.tokenSecret
            && showAvatar == other.showAvatar
            && showUsername == other.showUsername
            && showTimestamp == other.showTimestamp
            && showReplyTo == other.showReplyTo
            && highlightUrls == other.highlightUrls
            && highlightMentions == other.highlightMentions
            && highlightTags == other.highlightTags
            && lastTweets == other.lastTweets);
}

QDataStream &operator<<( QDataStream &out, const Account &entry )
{
    out << entry.user;
    out << entry.avatar;
    out << entry.token;
    out << entry.tokenSecret;
    out << entry.lastTweets;
    out << entry.showAvatar;
    out << entry.showUsername;
    out << entry.showTimestamp;
    out << entry.showReplyTo;
    out << entry.highlightUrls;
    out << entry.highlightMentions;
    out << entry.highlightTags;
    return out;
}

QDataStream &operator>>( QDataStream &in, Account &entry )
{
    in >> entry.user;
    in >> entry.avatar;
    in >> entry.token;
    in >> entry.tokenSecret;
    in >> entry.lastTweets;
    in >> entry.showAvatar;
    in >> entry.showUsername;
    in >> entry.showTimestamp;
    in >> entry.showReplyTo;
    in >> entry.highlightUrls;
    in >> entry.highlightMentions;
    in >> entry.highlightTags;
    return in;
}
