/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TIMELINEVIEW_H
#define TIMELINEVIEW_H

#include "backend.h"
#include "applicationItems/lineedit.h"
#include "applicationItems/loader.h"
#include "applicationItems/twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"
#include "applicationItems/twittercheckbox.h"
#include "applicationItems/twittertopbar.h"
#include "applicationItems/twittertweetinfo.h"
#include "applicationItems/timelinesettings.h"
#include "urlshortener.h"
#include "location/getiplocation.h"

#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
    #include <location/maemo5gps.h>
#endif

/*!
 * \class TimelineView
 *
 * \brief Timeline window with customized widgets.
 */
class TimelineView : public QGraphicsWidget
{
    Q_OBJECT

public:
    TimelineView(void);
    void createUi(void);
    void setUpdateMessage(const QString &message);
    void updateTopBar(void);
    QString getUpdateMessage(void);
    void addMoreButton(Timeline::TimelineType);
    void tweetDeleted(quint64);
    void clearText(void);

public slots:
    void endLoader(void);
    void startLoader(void);
    void getIPCoordinates(void);
    void getGPSCoordinates(void);
    void setLocationCheckboxFalse(void);

signals:
    void postUpdate(void);
    void shorteningError(QString);
    void favorite(QString, bool);
    void deleteTweet(quint64);
    void logout(void);
    void unfollow(QString, bool);
    void done(void);
    void coordinatesOk(void);
    void changeAvatar(QString);
    void showLocationDialog(void);
    void gotGPS(void);
    void homeRefresh(void);
    void mentionsRefresh(void);
    void loadMap(void);
    void moreHomeTweets(void);
    void moreMentions(void);
    void getTimeline(Timeline::TimelineType);

private slots:
    void _deleteLoader(void);
    void _enableTweetButton(QString);
    void _handleNewMessage(QString newMessage);
    void _handleReply(QString newMessage, quint64 statusId);
    void _createTweetInfo(Tweet *tweet);
    void _backToLogin(void);
    void _emitRefresh(void);
    void _emitPostUpdate(void);
    void _emitMoreTweets(void);
    void _emitUnfollow(QString, bool);
    void _emitDelete(quint64, Tweet*);
    void _emitFavorite(QString, bool);
    void _emitChangeAvatar(QString);
    void _createTimeline(void);
    void _toHome(void);
    void _toMentions(void);
    void _showIpLocationInfo(double latitude, double longitude);

private:
    QAbstractAnimation *_createEntryAnimation(void);
    QAbstractAnimation *_createExitAnimation(void);
    void _createEntry(void);
    void _createButtons(void);
    void _createTopBar(void);
    void _createSettings(void);
    void _moveToLeft(KineticList*, KineticList*);
    void _moveToRight(KineticList*, KineticList*);
    void _moveTimelines(KineticList*, KineticList*);
    void _addOpacityAnim(QParallelAnimationGroup *anim,
                         TwitterApplicationItem *item,
                         int delay);
    void _addPosAnim(QParallelAnimationGroup *anim,
                     TwitterApplicationItem *item,
                     QPointF startValue, QPointF endValue,
                     QEasingCurve easing, int delay);

private:
    QAbstractAnimation *_exitAnim;
    QAbstractAnimation *_entryAnim;
    KineticList *timelineOnScreen;
    Loader *_loader;
    LineEdit *_entryUpdate;
    Tweet *m_deleteTweet;
    QPointF leftPos;
    QPointF centerPos;
    QPointF rightPos;
    QList<KineticList*> _timelines;
    QList<bool> _downloadedTimelines;

public:
    quint64 m_statusId;
    TwitterTopBar *_topBar;
    TwitterTweetInfo *_tweetInfo;
    TwitterButton *_updateButton;
    TwitterButton *_exposeButton;
    TwitterCheckBox *_locationCheckBox;
    UrlShortener *_urlShortener;
    IpLocation *_ipLocation;
    KineticList *_homeTimeline;
    KineticList *_mentionsTimeline;
    TimelineSettings *_settingsDialog;

    bool isReply;

    #ifdef Q_WS_MAEMO_5
        Maemo5GPS *_gpsLocation;
    #endif
};

#endif // TIMELINEVIEW_H
