/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "getiplocation.h"

/*! \brief IpLocation constructor.
 */
IpLocation::IpLocation(QObject *parent) : QObject(parent)
{
    connection = new QNetworkAccessManager(this);
    connect(connection, SIGNAL(finished(QNetworkReply *)), this, SLOT(replyFinished(QNetworkReply *)));
}

/*!
 * \brief IpLocation destructor.
 */
IpLocation::~IpLocation()
{
}

/*!
 * \brief Sends a HTTP POST to the url asking for location information.
 */
void IpLocation::getLocation()
{
    QByteArray post = QByteArray("{\"version\": \"1.1.0\", \"host\": \"maps.google.com\"}");
    connection->post(QNetworkRequest( QUrl ("http://www.google.com/loc/json") ), post);
}

/*!
 * \brief This function reads the response and emits a signal when location information is saved.
 * \param reply response object
 */
void IpLocation::replyFinished(QNetworkReply *reply)
{
    QString response = reply->readAll();
    QRegExp location ("\\{\"latitude\":(.*),\"longitude\":(.*),\"accuracy\":(.*)\\}");
    location.setMinimal(1);
    location.indexIn(response, 1);
    latitude = location.capturedTexts().at(1).toDouble();
    longitude = location.capturedTexts().at(2).toDouble();
    accuracy = location.capturedTexts().at(3).toDouble();
    emit finished(latitude, longitude);
}

/*! \brief Returns latitude value.
 * \return latitude Latitude
 */
double IpLocation::getLat()
{
    return latitude;
}

/*! \brief Returns longitude value.
 * \return longitude Longitude
 */
double IpLocation::getLon()
{
    return longitude;
}

/*! \brief Returns accuracy value.
 * \return accuracy Accuracy
 */
double IpLocation::getAcc()
{
    return accuracy;
}
