/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef LINEEDIT_H
#define LINEEDIT_H

#include <QtGui/QLineEdit>
#include <QtGui/QGraphicsProxyWidget>

#include "twitterapplicationitem.h"

/*!
 * \class LineEditBox
 *
 * \brief Inherits from QLineEdit and implements
 * a clicked signal.
 */
class LineEditBox : public QLineEdit
{
    Q_OBJECT

public:
    LineEditBox()
            : QLineEdit() {
    }

    ~LineEditBox() {
    }

protected:
    void focusInEvent(QFocusEvent *event) {
        QLineEdit::focusInEvent(event);
        emit gainedFocus();
    }

    void focusOutEvent(QFocusEvent *event) {
        QLineEdit::focusOutEvent(event);
        emit lostFocus();
    }

signals:
    void gainedFocus(void);
    void lostFocus(void);
};

/*!
 * \class LineEdit
 *
 * \brief Creates a graphical entry box
 * that can be added to a QGraphicsScene.
 */
class LineEdit : public TwitterApplicationItem
{
    Q_OBJECT

public:
    enum TypeLineEdit{ Short, Long };

    LineEdit(LineEdit::TypeLineEdit type , QGraphicsWidget *parent = 0);
    ~LineEdit();
    void setEchoMode(QLineEdit::EchoMode echo);
    void setMessage(QString message);
    QString getText(void);
    QGraphicsProxyWidget *getEntry(void);
    void enable(bool option);
    void setMaxLength(int length);
    void clearText(void);

    QRectF boundingRect() const {
        return _image->boundingRect();
    }

public slots:
    void selectAll(void);
    void gainedFocus(void);
    void lostFocus(void);

signals:
    void enterPressed(void);
    void textChanged(void);

private:
    void _createCounter(void);
    void _createBackground(void);
    void _createEntry(void);

private slots:
    void _updateCounter(void);

protected:
    virtual void keyReleaseEvent(QKeyEvent *event);
    virtual void mousePressEvent(QGraphicsSceneMouseEvent *event);
    virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event);
    virtual void keyPressEvent(QKeyEvent *event);

private:
    QGraphicsPixmapItem *_image;
    QGraphicsProxyWidget *_entry;
    QLineEdit *_entryWidget;
    int _type;
    QGraphicsTextItem *counter;
    QFont font;
};

#endif
