/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef APPLICATIONMANAGER_H
#define APPLICATIONMANAGER_H

#include <QtGui/QGraphicsScene>

#include "loginScreen/loginctrl.h"
#include "timelineScreen/timelinectrl.h"

/*!
 * \class ApplicationManager
 * \brief Creates a new instance of the controller for each state.
 */
class ApplicationManager : public QObject
{
    Q_OBJECT

public:
    ApplicationManager(QGraphicsScene *scene);

private:
    QGraphicsScene *_scene;
    LoginCtrl *_loginCtrl;
    TimelineCtrl *_timelineCtrl;

public slots:
    void loginScreen(void);
    void timelineScreen(void);

signals:
    void loginFinished(void);
    void timelineFinished(void);

private:
    bool _autologin;
};

#endif // APPLICATIONMANAGER_H
