/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef USER_H
#define USER_H

#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtGui/QPainter>

#include "twitterapi/entry.h"
#include "twitterapplicationitem.h"

class User : public TwitterApplicationItem
{
    Q_OBJECT

public:
    User(QString username, QImage avatar, int pos, QGraphicsWidget *parent=0);
    void unselect(void);
    void select(void);

signals:
    void selected(int pos);

private:
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
    void drawName(bool isSelected);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

private:
    QGraphicsTextItem *_name;
    QImage _defaultAvatar;
    QString *_avatarUrl;
    QString _username;
    QColor _bgColor;
    QImage _avatar;
    int _pos;
};

#endif // USER_H
