#ifndef LOGINSETTINGS_H
#define LOGINSETTINGS_H

#include "twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"
#include "applicationItems/twittercheckbox.h"

class LoginSettings : public TwitterApplicationItem
{
    Q_OBJECT

public:
    LoginSettings(QGraphicsWidget *parent);
    void setSelected(int selected);

public slots:
    void startAnimation(void);

private slots:
    void _exitAnimation(void);
    void _autoLogin(void);

private:
    void _loadSettings(void);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

private:
    QGraphicsPixmapItem *_bg;
    QGraphicsTextItem *_title;
    QGraphicsLineItem *_sep1;
    QGraphicsLineItem *_sep2;
    TwitterButton *_backButton;
    TwitterCheckBox *_autologinCheckBox;
    bool autologin;
    QFont font;
    int _sel;
};

#endif // LOGINSETTINGS_H
