/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "splashctrl.h"

/*! 
 * \brief SplashCtrl constructor.
 */
SplashCtrl::SplashCtrl(QGraphicsScene *scene)
{
    qDebug() << "+ " << __PRETTY_FUNCTION__;

    _scene = scene;
    _scene->setBackgroundBrush(QPixmap(":images/resources/Background.png"));

    _view = new SplashView();
    showView();

    connect(_view,SIGNAL(done()),this,SLOT(deleteLater()));
}

/*!
 * \brief SplashCtrl destructor.
 */
SplashCtrl::~SplashCtrl(void)
{
    qDebug() << "~ " << __PRETTY_FUNCTION__;

    if (_view)
        delete(_view);

    emit done();

    qDebug() << "DELETED SplashCtrl object : " << this;
}

/*!
 * \brief Creates the view and add the scene.
 */
void SplashCtrl::showView(void)
{
    _view->createUi();
    _scene->addItem(_view);
}
