/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef STATUSLIST_H
#define STATUSLIST_H

#include <QtGui/QGraphicsLinearLayout>

#include "twitterapplicationitem.h"
#include "applicationItems/tweet.h"
#include "applicationItems/twitterbutton.h"

class StatusList : public TwitterApplicationItem
{
    Q_OBJECT

public:
    StatusList(QGraphicsWidget *parent = 0);
    void setVisibleRect(const QRectF &rect);
    QRectF getVisibleRect() const;
    void clearList(void);
    void addMoreButton(void);
    void removeMoreButton(void);
    void removeFromList(int position);
    void populateFollowing(QString username, bool follow);
    void moreButtonEnable(bool enable);

signals:
    void createTweetInfo(Tweet *tweet);
    void morePressed(void);

private slots:
    void _addToList(const QString &name, const QString &text, const QString &imageUrl,
                   const QString &statusId, const QString &createdAt, const QString &source,
                   const bool &favorite, const QString &coordinates, bool isMyTweet, bool isUpdate);
    void _moreTweets(void);

private:
    QGraphicsLinearLayout *m_layout;
    QRectF m_visibleRect;
    TwitterButton *m_moreButton;
};

#endif //STATUSLIST_H
