/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TIMELINECTRL_H
#define TIMELINECTRL_H

#include <QtCore/QObject>
#include <QtGui/QGraphicsProxyWidget>
#include <QtGui/QGraphicsScene>

#include "timelineview.h"
#include "backend.h"
#include "applicationItems/dialog.h"

/*! \class TimelineCtrl
 *
 * \brief TimelineCtrl class is the controller to %TimelineView.
 */
class TimelineCtrl : public QObject
{
    Q_OBJECT

public:
    TimelineCtrl(QGraphicsScene *scene);
    ~TimelineCtrl();
    void showView();

private:
    QGraphicsScene *_scene;
    TimelineView *_timelineView;
    QPropertyAnimation *_anim;
    QPropertyAnimation *_animMap;
    QPropertyAnimation *_animInfo;
    QPropertyAnimation *_animLogoutButton;
    QPropertyAnimation *_animRefreshButton;
    QPropertyAnimation *_animBackButton;
    QPropertyAnimation *_animTweetButton;
    QPropertyAnimation *_animMapButton;

private slots:
    void _postNewUpdate(void);
    void _connectionError(QString);
    void _genericError(QString);
    void _showTimeline(void);
    void _handleRetweet(void);
    void _handleReply(void);
    void _handleFavorite(QString);
    void _handleDeleteTweet(void);
    void _logout(void);
    void _changeToTweetInfo(void);
    void _changeToTimeline(void);
    void _handleFriendship(void);
    void _updateWarning(QString);
    void _refreshWarning(QString);
    void _updateTimeline(void);
    void _downloadMoreTweets(void);
    void _loadMap(void);
    void _hideMap(void);
    void _updateProfileImage(QString);

public:
    QGraphicsProxyWidget *timelineProxy;
    QGraphicsProxyWidget *timelineProxy2;

private:
    QEasingCurve easingCurve;
    int animationDuration;
    bool atTimeline;
    bool isFollowing;
    bool updateTimeline;
    bool isMapOn;
    int cont;

signals:
    void done(void);
};

#endif // TIMELINECTRL_H

