/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef IPLOCATION_H
#define IPLOCATION_H

#include <QObject>
#include <QDebug>
#include <QUrl>
#include <QNetworkAccessManager>
#include <QRegExp>
#include <QStringList>
#include <QNetworkRequest>
#include <QNetworkReply>

/*!
 * \class IpLocation
 *
 * \brief IpLocation class handles all operations related to obtaining geographical coordinates over the internet.
 */
class IpLocation : public QObject {
    Q_OBJECT

signals:
    void finished();

public slots:
    void getLocation();

public:
    IpLocation(QObject *parent = 0);
    ~IpLocation();
    double getLat();
    double getLon();
    double getAcc();

private slots:
    void replyFinished(QNetworkReply *reply);

private:
    double latitude;
    double longitude;
    double accuracy;
    QNetworkAccessManager *connection;
};

#endif // IPLOCATION_H
